/*
Arcanum universal level cap remover v0.0.1
Copyright (C) 2003  Alqualos (alqualos@yandex.ru)

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
*/

// Main (and the only) source file
// This file has UNIX line terminator (LF)

#include <stdio.h>
#include <stdlib.h>
int off_1=5;
int size_1=20;
int template1[][2]={
  {0,0x56},
  {1,0x57},
  {2,0x6A},
  {3,0x04},
  {4,0x6A},
  {6,0xE8},
  {11,0x6A},
  {12,0x04},
  {13,0x6A},
  {14,0x0A},
  {15,0xA3},
  {20,0xE8},
  {25,0x83},
  {28,0xA3},
  {33,0x33},
  {34,0xF6},
  {35,0x8B},
  {36,0x54},
  {37,0x24},
  {38,0x08}
};
int off_2=17;
int size_2=23;
int template2[][2]={
  {0,0x8B},
  {1,0x15},
  {6,0xC7},
  {7,0x04},
  {8,0xB2},
  {9,0x00},
  {10,0x00},
  {11,0x00},
  {12,0x00},
  {13,0x8B},
  {14,0xF7},
  {15,0x83},
  {16,0xFE},
  {18,0x7C},
  {20,0x8B},
  {21,0x44},
  {22,0x24},
  {23,0x08},
  {24,0x50},
  {25,0xE8},
  {30,0x8B},
  {31,0x0D},
  {36,0x68}
};
int off_3=5;
int size_3=25;
int template3[][2]={
  {0,0x83},
  {1,0xC4},
  {2,0x0C},
  {3,0x83},
  {4,0xF8},
  {6,0x7D},
  {8,0x8B},
  {9,0x0D},
  {14,0x56},
  {15,0x6A},
  {16,0x12},
  {17,0x57},
  {18,0x8B},
  {21,0x53},
  {22,0xE8},
  {27,0x83},
  {28,0xC4},
  {29,0x0C},
  {30,0x2B},
  {31,0xF0},
  {32,0x8B},
  {33,0xC6},
  {34,0x5E},
  {35,0x5F},
  {36,0x5B}
};
int off_4=7;
int size_4=22;
int template4[][2]={
  {0,0x8B},
  {1,0xF0},
  {2,0x83},
  {3,0xC4},
  {4,0x0C},
  {5,0x83},
  {6,0xFE},
  {8,0x7D},
  {10,0x85},
  {11,0xF6},
  {12,0x74},
  {14,0xA1},
  {19,0x83},
  {23,0x74},
  {25,0x57},
  {26,0x53},
  {27,0xE8},
  {32,0x83},
  {33,0xC4},
  {34,0x08},
  {35,0x85},
  {36,0xC0}
};
int off_5=4;
int size_5=12;
int template5[][2]={
  {0,0x64},
  {1,0x00},
  {2,0x00},
  {3,0x00},
  {5,0x00},
  {6,0x00},
  {7,0x00},
  {8,0x00},
  {16,0x64},
  {17,0x00},
  {18,0x00},
  {19,0x00}
};
int check_template(int template[][2], const char* array, int templ_size)
{
  int i;
  for(i=0; i<templ_size; i++){
    if((unsigned char)array[template[i][0]]!=(unsigned)template[i][1]) return 0;
  }
  return 1;
}
int find_template(int template[][2], const char* array, int start, int size, int templ_size)
{
  int i;
  for(i=start; i<size; i++){
    if((unsigned char)array[i]==(unsigned)template[0][1]){
      if(i+template[templ_size-1][0]>=size) return 0;
      //printf("Checking at offset 0x%08X...\n",i);
      if(check_template(template,array+i,templ_size)) return i;
    }
  }
  return 0;
}
//unsigned char test[]={0x56,0x57,0x6A,0x04,0x6A,0x50,0xE8,0x0x6A
int main(int argc, char** argv)
{
  static char *bytes;
  long filesize;
  int c, pos1, pos2, pos3, pos4, pos5, lev1, lev2, lev3, lev4, lev5;
  int i, newlev;
  FILE *handle, *bak;
  printf("Arcanum universal level cap remover v0.0.1\n\
Copyright (C) 2003  Alqualos, alqualos@yandex.ru, http://brededor.narod.ru\n\
The latest version is available on\n\
http://brededor.narod.ru/progs/arcanum50patch.htm\n\
This program is free software. See COPYING file (GNU GPL) for details.\n");
  if((handle=fopen("arcanum.exe","rb"))==NULL)
  {
    printf("arcanum.exe not found!\n\
Please place this patch in the Arcanum directory before running...\n\
Press enter to exit...\n");
    getchar();
    exit(1);
  }
  fseek(handle,0,SEEK_END);
  filesize=ftell(handle);
  fseek(handle,0,SEEK_SET);
  if((bak=fopen("arcanum.50","rb"))!=NULL){
    fclose(bak);
  }else{
    if((bak=fopen("arcanum.50","wb"))==NULL){
      printf("Can\'t make backup of arcanum.exe:\n\
Can\'t open arcanum.50 for write access.\n\
Press enter to exit...\n");
      exit(2);
    }
    while((c=getc(handle))!=EOF) putc(c,bak);
    fclose(bak);
  }
  fseek(handle,0,SEEK_SET);
  bytes=malloc(filesize);
  fread(bytes,1,filesize,handle);
  fclose(handle);
  pos1=find_template(template1,bytes,0,filesize,size_1);
  if(find_template(template1,bytes,pos1+1,filesize,size_1)){
    printf("Oops! Template 1 was found more than once!\n\
It seems impossible to patch this version of Arcanum.\n\
Send its .exe file to alqualos@yandex.ru if you still want to patch it!\n\
Press enter to exit...\n");
    getchar();
    exit(1);
  }
  if(pos1==0){
    printf("Oops! Template 1 was not found!\n\
It seems impossible to patch this version of Arcanum.\n\
Send its .exe file to alqualos@yandex.ru if you still want to patch it!\n\
Press enter to exit...\n");
    getchar();
    exit(1);
  }
  lev1=(unsigned char)bytes[pos1+off_1];
  printf("Template 1 found at offset 0x%08X... levelcap=%d\n",pos1,lev1);
  pos2=find_template(template2,bytes,0,filesize,size_2);
  if(find_template(template2,bytes,pos2+1,filesize,size_2)){
    printf("Oops! Template 2 was found more than once!\n\
It seems impossible to patch this version of Arcanum.\n\
Send its .exe file to alqualos@yandex.ru if you still want to patch it!\n\
Press enter to exit...\n");
    getchar();
    exit(1);
  }
  if(pos2==0){
    printf("Oops! Template 2 was not found!\n\
It seems impossible to patch this version of Arcanum.\n\
Send its .exe file to alqualos@yandex.ru if you still want to patch it!\n\
Press enter to exit...\n");
    getchar();
    exit(1);
  }
  lev2=(unsigned char)bytes[pos2+off_2];
  printf("Template 2 found at offset 0x%08X... levelcap=%d\n",pos2,lev2);
  pos3=find_template(template3,bytes,0,filesize,size_3);
  if(find_template(template3,bytes,pos3+1,filesize,size_3)){
    printf("Oops! Template 3 was found more than once!\n\
It seems impossible to patch this version of Arcanum.\n\
Send its .exe file to alqualos@yandex.ru if you still want to patch it!\n\
Press enter to exit...\n");
    getchar();
    exit(1);
  }
  if(pos3==0){
    printf("Oops! Template 3 was not found!\n\
It seems impossible to patch this version of Arcanum.\n\
Send its .exe file to alqualos@yandex.ru if you still want to patch it!\n\
Press enter to exit...\n");
    getchar();
    exit(1);
  }
  lev3=(unsigned char)bytes[pos3+off_3];
  printf("Template 3 found at offset 0x%08X... levelcap=%d\n",pos3,lev3);
  pos4=find_template(template4,bytes,0,filesize,size_4);
  if(find_template(template4,bytes,pos4+1,filesize,size_4)){
    printf("Oops! Template 4 was found more than once!\n\
It seems impossible to patch this version of Arcanum.\n\
Send its .exe file to alqualos@yandex.ru if you still want to patch it!\n\
Press enter to exit...\n");
    getchar();
    exit(1);
  }
  if(pos4==0){
    printf("Oops! Template 4 was not found!\n\
It seems impossible to patch this version of Arcanum.\n\
Send its .exe file to alqualos@yandex.ru if you still want to patch it!\n\
Press enter to exit...\n");
    getchar();
    exit(1);
  }
  lev4=(unsigned char)bytes[pos4+off_4];
  printf("Template 4 found at offset 0x%08X... levelcap=%d\n",pos4,lev4);
  pos5=find_template(template5,bytes,0,filesize,size_5);
  if(find_template(template5,bytes,pos5+1,filesize,size_5)){
    printf("Oops! Template 5 was found more than once!\n\
It seems impossible to patch this version of Arcanum.\n\
Send its .exe file to alqualos@yandex.ru if you still want to patch it!\n\
Press enter to exit...\n");
    getchar();
    exit(1);
  }
  if(pos5==0){
    printf("Oops! Template 5 was not found!\n\
It seems impossible to patch this version of Arcanum.\n\
Send its .exe file to alqualos@yandex.ru if you still want to patch it!\n\
Press enter to exit...\n");
    getchar();
    exit(1);
  }
  lev5=(unsigned char)bytes[pos5+off_5];
  printf("Template 5 found at offset 0x%08X... levelcap=%d\n",pos5,lev5);
  printf("Cool! All templates was found. Now checking for current levelcap...\n");
  if(!(lev1==lev2&&lev2==lev3&&lev3==lev4&&lev4==lev5)){
    printf("Oops! Cannot determine current levelcap!\n\
It seems there was some mistake... press enter to exit...\n");
    getchar();
    exit(1);
  }
  printf("Yeah! It looks like everything is allright!\n\
Current levelcap is %d.\n\
Please enter new levelcap (value between 1 and 127): ",lev1);
  if(scanf("%d",&newlev)!=1||newlev<1||newlev>127){
    c=getchar();
    while(c!='\n') c=getchar();
    printf("Ha! You think you can fool me!\n\
No, you must enter value between 1 and 127!\n\
Sadly, Arcanum doesn\'t support other values...\n\
Press enter to exit...\n");
    getchar();
    exit(1);
  }
  c=getchar();
  while(c!='\n') c=getchar();
  bytes[pos1+off_1]=newlev;
  bytes[pos2+off_2]=newlev;
  bytes[pos3+off_3]=newlev;
  bytes[pos4+off_4]=newlev;
  bytes[pos5+off_5]=newlev;
  if((handle=fopen("arcanum.exe","wb"))==NULL){
    printf("Oh no! I cannot open arcanum.exe for writing!\n\
Make sure that arcanum.exe hasn't read only bit set (see file properties) and\n\
you aren\'t running the game right now and try again.\n\
Press enter to exit...\n");
    getchar();
    exit(2);
  }
  fwrite(bytes,1,filesize,handle);
  fclose(handle);
  printf("Patch was successful. New levelcap=%d. Enjoy!\n\
Press enter to continue...\n",newlev);
  getchar();
  free(bytes);
  return 0;
}
