using System;
using System.Windows.Forms;
using System.Drawing;
using System.Reflection;

namespace epgviewer
{
	/// <summary>
	/// Summary description for Class1.
	/// </summary>
	// inherit from ComboBox 
	public class ColorComboBox : ComboBox 
	{ 
		// We need a property to get and set current color 
		public Color Color 
		{ 
			get 
			{ 
				if(this.Text.Length > 0) 
					return Color.FromName(this.Text); 
				else 
					return Color.Black; 
			} 
			set 
			{ 
				this.Text = value.Name; 
			} 
		} 

		public ColorComboBox() 
		{ 
			this.Text = ""; 
			this.SelectedIndex = -1; 
			this.DropDownStyle = ComboBoxStyle.DropDownList; 
			this.DrawMode = DrawMode.OwnerDrawFixed; 
			this.Width = 120; 

			// Since the colors aren't enumerated, we can use Type.GetProperties() 
			// to get all colors. 
			// This will return colors listed under "Web" 
			Color c = Color.Black; 
			Type t = c.GetType();
                   
            Color sc = SystemColors.WindowText;
            this.Items.Add(sc.Name);

			PropertyInfo[] pis = t.GetProperties();                 
			foreach(PropertyInfo p in pis) 
			{ 
				// Filter out all properties that aren't colors and add to the dropdownlist 
				if(p.PropertyType == typeof(System.Drawing.Color)) 
					if (p.Name.ToLower()!="transparent") {this.Items.Add(p.Name);} 
			}
		} 

		// The combobox is set to OwnerDrawFixed, so we are responsible to draw all items 
		protected override void OnDrawItem(DrawItemEventArgs e) 
		{ 
			if(e.Index == -1) 
				return; 

			// Get the name of the current item to be drawn, and make a brush of it 
			string s = (string)this.Items[e.Index]; 
			SolidBrush b = new SolidBrush(Color.FromName(s)); 
			// Draw a rectangle and fill it with the current color 
			// and add the name to the right of the color 
			e.Graphics.DrawRectangle(Pens.Black, 3, e.Bounds.Top+1, 20, 11); 
			e.Graphics.FillRectangle(b, 4, e.Bounds.Top+2, 19, 10); 
			e.Graphics.DrawString(s, this.Font, Brushes.Black, 25, e.Bounds.Top); 
			b.Dispose(); 
		} 
	} 
}
