using System; 
using System.Windows.Forms; 
using System.Text; 
using System.Drawing; 
using System.Runtime.InteropServices;
using Microsoft.Win32;
using System.Diagnostics; 


namespace Utils 
{ 
	
	
	
	public struct MyListBoxItem
	{
		public string itemData;
		public string itemText;
		public override string ToString()
		{
			return itemText;
		}
	}

	public struct DigiTVChannel
	{
		public int LCN;
		public string ChannelName;
		public string Freq;
		public override string ToString()
		{
			return ChannelName;
		}
	}

	public struct ProgrammeDetail
	{
		public string Desc;
		public string Subtitle;
        public string ChannelID;
		public string ChannelName;
		public DateTime Start;
		public int Duration;
		public string DurUnits;

		public override string ToString()
		{
			return Desc;
		}
	}

	
	public class General
	{
		public static bool bDigiTVInstalled;
		public static bool bStartDigiTV;
		public static  string strDigiPath;
		public const string beta="";
		public static bool TimersSet;
        public static Color todayColour=SystemColors.WindowText;
        public static Color tomorrowColour=SystemColors.WindowText;
        public static bool Twenty4HourView;
        public static bool LoadLastFile;
        public static bool RefreshNeeded;
        public static bool FontChanged;
        public static string FontName = "Tahoma";
        public static float FontSize = 8.25F;
        public static bool EnableVisualStyles = true;
        public static bool InitialEnableVisualStyles;
        public static bool RestrictDropdownHeight;
        public static int TimerLimit = 49;

		public static int BinaryToInt(byte[] byt)
		{
			//RegistryKey key=(RegistryKey)obj;
			
			string sByte="";
			int iHex=0;
			string sHex="";

			Array.Reverse(byt); //reverse byte order
			for(int i=0;i<=byt.Length-1;i++)
			{
				sByte = byt[i].ToString();
				iHex=int.Parse(sByte);
				sHex=sHex+iHex.ToString("x");
			}

			UInt32 intYear=System.UInt32.Parse(sHex, System.Globalization.NumberStyles.HexNumber);
			return (int)intYear;
		}

		public static bool SetTimer(DateTime dt, string RTChannelID, int mins, string ProgName)
		{
			//bool status=false;
			string[] timer;
			int highest=-1;
			int overlap=1;
			RegistryKey key;
			RegistryKey skey;

			DateTime newtimerstart=dt;
			DateTime newtimerstop=newtimerstart.AddMinutes(mins);
			
			string DigiChannelName="";
			string RTName="";
			string newtimermux="";
			int DigiChannel=0;
			

			// create a Timer subkey if one doesn't exist
			RegistryKey testkey=Registry.LocalMachine.CreateSubKey(@"Software\Nebula\DigiTV\Timer");
			testkey.Close();

			key = Registry.CurrentUser.OpenSubKey(@"Software\XMLTV EPG Viewer\ChannelMappings");
			if (key==null)
			{
				throw new Exception("The channel mappings have not yet been set up. Go to 'DigiTV Settings' in the Options.");
				return false;
			}

			skey=key.OpenSubKey(RTChannelID.ToString());
			if (skey==null)
			{
				throw new Exception("The channel mappings have not yet been set up. Go to 'DigiTV settings' in the Options.");
				return false;
			}
			else
			{
				DigiChannel=int.Parse(skey.GetValue("DigiID").ToString());
				DigiChannelName=skey.GetValue("DigiName").ToString();
				RTName=skey.GetValue("RTName").ToString();
				newtimermux=skey.GetValue("DigiFreq").ToString();
				skey.Close();
			}

			if (DigiChannel==0)
			{
				throw new Exception("The Radio Times channel '"+RTName+"' has not yet been mapped to a DigiTV channel.");
				return false;
			}
			if(newtimerstop<DateTime.Now)
			{
				throw new Exception("This TV programme has already finished!");
				return false;
			}

			key=Registry.LocalMachine.OpenSubKey(@"Software\Nebula\DigiTV\Timer");
			timer=key.GetSubKeyNames();
			int n=timer.Length;
			int[] timerarray=new int[n];
			
			for(int i=0;i<=timer.Length-1;i++)
			{
				timerarray[i]=int.Parse(timer[i].Replace("Program",""));

				if(int.Parse(timer[i].Replace("Program",""))>highest)
				{
					highest=int.Parse(timer[i].Replace("Program",""));
				}
			}
			Array.Sort(timerarray);
			//Array.

			//timerarray.
			//for(int i=0;i<=timer.Length-1;i++)

			for(int i=0;i<=timer.Length-1;i++)
			{
				//bool timerclash=false;
				RegistryKey timerkey=Registry.LocalMachine.OpenSubKey(@"Software\Nebula\DigiTV\Timer\"+timer[i]);
				int day=BinaryToInt((byte[])timerkey.GetValue("Day"));
				int month=BinaryToInt((byte[])timerkey.GetValue("Month"));
				int hour=BinaryToInt((byte[])timerkey.GetValue("Hour"));
				int min=BinaryToInt((byte[])timerkey.GetValue("Min"));
				int year=BinaryToInt((byte[])timerkey.GetValue("Year"));
				int length=BinaryToInt((byte[])timerkey.GetValue("Length"));
				int channel=BinaryToInt((byte[])timerkey.GetValue("Channel"));

				string currtimermux="", currchannelname="";

				RegistryKey channelkey=Registry.LocalMachine.OpenSubKey(@"Software\Nebula\DigiTV\Channels");
				string[] channelname=channelkey.GetSubKeyNames();
				for(int j=0;j<=channelname.Length-1;j++)
				{
					RegistryKey subkey=channelkey.OpenSubKey(channelname[j]);
					int lcn=(int)BinaryToInt((byte[])subkey.GetValue("LCN"));
					if (lcn==channel)
					{
						currtimermux=subkey.GetValue("Frequency").ToString();
						currchannelname=subkey.GetValue("Name").ToString();
					}
				}

				string currProg=timerkey.GetValue("Program").ToString();
				DateTime currtimerstart = new DateTime(year,month,day,hour,min,0,0);
				DateTime currtimerstop = currtimerstart.AddMinutes(length);

				timerkey.Close();

				timerkey=Registry.LocalMachine.OpenSubKey(@"Software\XMLTV EPG Viewer\ChannelMappings\"+channel.ToString());

				if((newtimerstart>=currtimerstart && newtimerstart<=currtimerstop.AddMinutes(-overlap)) || (newtimerstop>=currtimerstart.AddMinutes(overlap) && newtimerstop<=currtimerstop) )
				{ //possible clash
					if (currtimermux==newtimermux)
					{ // same mux and time is okay
						if (DigiChannel==channel)
						{ //as long as channels are different
							throw new Exception("The timer below clashes with one already set for this time and channel:\n\n"+currProg+ " on " +currchannelname + " on "+ currtimerstart.ToLongDateString() + " between "+currtimerstart.ToShortTimeString()+" and "+currtimerstop.ToShortTimeString());
							return false;
						}
					}
					else
					{
						throw new Exception("The timer below clashes with one already set for this time and channel, which is on a different multiplex:\n\n"+currProg+ " on " +currchannelname + " on "+ currtimerstart.ToLongDateString() + " between "+currtimerstart.ToShortTimeString()+" and "+currtimerstop.ToShortTimeString());
						return false;
					}
				}

			}

			if(highest<49)
			{
				int newprog=highest+1;
				string newkey="Program " + newprog.ToString();
				key=Registry.LocalMachine.CreateSubKey(@"Software\Nebula\DigiTV\Timer\"+newkey);
				key.SetValue("Channel", IntToBinary(DigiChannel));
				key.SetValue("Day", IntToBinary(dt.Day));
				key.SetValue("Month", IntToBinary(dt.Month));
				key.SetValue("Hour", IntToBinary(dt.Hour));
				key.SetValue("Min", IntToBinary(dt.Minute));
				key.SetValue("Year", IntToBinary(dt.Year));
				key.SetValue("Length", IntToBinary(mins));
				key.SetValue("Multi", IntToBinary(0));
				key.SetValue("Program", ProgName);
			}
			else
			{
				throw new Exception("There are no more available timers.");
				return false;
			}

			return true;
		}

		public static byte[] IntToBinary (int i)
		{
			byte[] bytTemp=BitConverter.GetBytes(i); //returns d6 07 00 00
			byte[] byt={bytTemp[0],bytTemp[1]}; //only want first 2 bytes
			return byt;
		}
	}
	
	public class MessageBoxEx 
	{ 
		static IWin32Window _owner; 
		private static HookProc _hookProc; 
		private static IntPtr _hHook; 


		public static DialogResult Show(string text) 
		{ 
			Initialize(); 
			return MessageBox.Show(text); 
		} 


		public static DialogResult Show(string text, string caption) 
		{ 
			Initialize(); 
			return MessageBox.Show(text, caption); 
		} 


		public static DialogResult Show(string text, string caption, 
			MessageBoxButtons buttons) 
		{ 
			Initialize(); 
			return MessageBox.Show(text, caption, buttons); 
		} 


		public static DialogResult Show(string text, string caption, 
			MessageBoxButtons buttons, MessageBoxIcon icon) 
		{ 
			Initialize(); 
			return MessageBox.Show(text, caption, buttons, icon); 
		} 


		public static DialogResult Show(string text, string caption, 
			MessageBoxButtons buttons, MessageBoxIcon icon, MessageBoxDefaultButton 
			defButton) 
		{ 
			Initialize(); 
			return MessageBox.Show(text, caption, buttons, icon, defButton); 
		} 


		public static DialogResult Show(string text, string caption, 
			MessageBoxButtons buttons, MessageBoxIcon icon, MessageBoxDefaultButton 
			defButton, MessageBoxOptions options) 
		{ 
			Initialize(); 
			return MessageBox.Show(text, caption, buttons, icon, defButton, 
				options); 
		} 


		public static DialogResult Show(IWin32Window owner, string text) 
		{ 
			_owner = owner; 
			Initialize(); 
			return MessageBox.Show(owner, text); 
		} 


		public static DialogResult Show(IWin32Window owner, string text, 
			string caption) 
		{ 
			_owner = owner; 
			Initialize(); 
			return MessageBox.Show(owner, text, caption); 
		} 


		public static DialogResult Show(IWin32Window owner, string text, 
			string caption, MessageBoxButtons buttons) 
		{ 
			_owner = owner; 
			Initialize(); 
			return MessageBox.Show(owner, text, caption, buttons); 
		} 


		public static DialogResult Show(IWin32Window owner, string text, 
			string caption, MessageBoxButtons buttons, MessageBoxIcon icon) 
		{ 
			_owner = owner; 
			Initialize(); 
			return MessageBox.Show(owner, text, caption, buttons, icon); 
		} 


		public static DialogResult Show(IWin32Window owner, string text, 
			string caption, MessageBoxButtons buttons, MessageBoxIcon icon, 
			MessageBoxDefaultButton defButton) 
		{ 
			_owner = owner; 
			Initialize(); 
			return MessageBox.Show(owner, text, caption, buttons, icon, 
				defButton); 
		} 


		public static DialogResult Show(IWin32Window owner, string text, 
			string caption, MessageBoxButtons buttons, MessageBoxIcon icon, 
			MessageBoxDefaultButton defButton, MessageBoxOptions options) 
		{ 
			_owner = owner; 
			Initialize(); 
			return MessageBox.Show(owner, text, caption, buttons, icon, 
				defButton, options); 
		} 


		public delegate IntPtr HookProc(int nCode, IntPtr wParam, IntPtr 
			lParam); 


		public delegate void TimerProc(IntPtr hWnd, uint uMsg, UIntPtr 
			nIDEvent, uint dwTime); 


		public const int WH_CALLWNDPROCRET = 12; 


		public enum CbtHookAction : int 
		{ 
			HCBT_MOVESIZE = 0, 
			HCBT_MINMAX = 1, 
			HCBT_QS = 2, 
			HCBT_CREATEWND = 3, 
			HCBT_DESTROYWND = 4, 
			HCBT_ACTIVATE = 5, 
			HCBT_CLICKSKIPPED = 6, 
			HCBT_KEYSKIPPED = 7, 
			HCBT_SYSCOMMAND = 8, 
			HCBT_SETFOCUS = 9 
		} 


		[DllImport("user32.dll")] 
		private static extern bool GetWindowRect(IntPtr hWnd, ref Rectangle 
			lpRect); 


		[DllImport("user32.dll")] 
		private static extern int MoveWindow(IntPtr hWnd, int X, int Y, int 
			nWidth, int nHeight, bool bRepaint); 


		[DllImport("User32.dll")] 
		public static extern UIntPtr SetTimer(IntPtr hWnd, UIntPtr nIDEvent, 
			uint uElapse, TimerProc lpTimerFunc); 


		[DllImport("User32.dll")] 
		public static extern IntPtr SendMessage(IntPtr hWnd, int Msg, IntPtr 
			wParam, IntPtr lParam); 


		[DllImport("user32.dll")] 
		public static extern IntPtr SetWindowsHookEx(int idHook, HookProc 
			lpfn, IntPtr hInstance, int threadId); 


		[DllImport("user32.dll")] 
		public static extern int UnhookWindowsHookEx(IntPtr idHook); 


		[DllImport("user32.dll")] 
		public static extern IntPtr CallNextHookEx(IntPtr idHook, int nCode, 
			IntPtr wParam, IntPtr lParam); 


		[DllImport("user32.dll")] 
		public static extern int GetWindowTextLength(IntPtr hWnd); 


		[DllImport("user32.dll")] 
		public static extern int GetWindowText(IntPtr hWnd, StringBuilder 
			text, int maxLength); 


		[DllImport("user32.dll")] 
		public static extern int EndDialog(IntPtr hDlg, IntPtr nResult); 


		[StructLayout(LayoutKind.Sequential)] 
			public struct CWPRETSTRUCT 
		{ 
			public IntPtr lResult; 
			public IntPtr lParam; 
			public IntPtr wParam; 
			public uint message; 
			public IntPtr hwnd; 
		} ; 


		static MessageBoxEx() 
		{ 
			_hookProc = new HookProc(MessageBoxHookProc); 
			_hHook = IntPtr.Zero; 
		} 


		private static void Initialize() 
		{ 
			if(_hHook != IntPtr.Zero) 
			{ 
				throw new NotSupportedException("multiple calls are not supported"); 
			} 


			if(_owner != null) 
			{ 
				_hHook = SetWindowsHookEx(WH_CALLWNDPROCRET, _hookProc, 
					IntPtr.Zero, AppDomain.GetCurrentThreadId()); 
			} 
		} 


		private static IntPtr MessageBoxHookProc(int nCode, IntPtr wParam, 
			IntPtr lParam) 
		{ 
			if(nCode < 0) 
			{ 
				return CallNextHookEx(_hHook, nCode, wParam, lParam); 
			} 


			CWPRETSTRUCT msg = (CWPRETSTRUCT) Marshal.PtrToStructure(lParam, 
				typeof (CWPRETSTRUCT)); 
			IntPtr hook = _hHook; 


			if(msg.message == (int) CbtHookAction.HCBT_ACTIVATE) 
			{ 
				try 
				{ 
					CenterWindow(msg.hwnd); 
				} 
				finally 
				{ 
					UnhookWindowsHookEx(_hHook); 
					_hHook = IntPtr.Zero; 
				} 
			} 


			return CallNextHookEx(hook, nCode, wParam, lParam); 
		} 


		private static void CenterWindow(IntPtr hChildWnd) 
		{ 
			Rectangle recChild = new Rectangle(0, 0, 0, 0); 
			bool success = GetWindowRect(hChildWnd, ref recChild); 


			int width = recChild.Width - recChild.X; 
			int height = recChild.Height - recChild.Y; 


			Rectangle recParent = new Rectangle(0, 0, 0, 0); 
			success = GetWindowRect(_owner.Handle, ref recParent); 


			Point ptCenter = new Point(0, 0); 
			ptCenter.X = recParent.X + ((recParent.Width - recParent.X)/2); 
			ptCenter.Y = recParent.Y + ((recParent.Height - recParent.Y)/2); 


			Point ptStart = new Point(0, 0); 
			ptStart.X = (ptCenter.X - (width/2)); 
			ptStart.Y = (ptCenter.Y - (height/2)); 


			ptStart.X = (ptStart.X < 0) ? 0 : ptStart.X; 
			ptStart.Y = (ptStart.Y < 0) ? 0 : ptStart.Y; 


			int result = MoveWindow(hChildWnd, ptStart.X, ptStart.Y, width, 
				height, false); 
		} 

	}
	
}