using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using Microsoft.Win32;
using System.Diagnostics;
using Utils;
using System.Drawing.Text;


namespace epgviewer
{
	/// <summary>
	/// Summary description for Form3.
	/// </summary>
	/// 
	

	public partial class Form3 : System.Windows.Forms.Form
    {
        private IContainer components;
		private System.Windows.Forms.Button buttonUpdate;
		private bool NoChannelsMapped=true;
		private bool NoChannelsTuned=true;
		
		public ComboBox cboTemp;
		//public StatusBar sbrTemp;
        //ColorComboBox colorComboToday;
        //ColorComboBox colorComboTomorrow;
		private System.Windows.Forms.TabControl tabControl1;
		private System.Windows.Forms.TabPage tpgGeneral;
		private System.Windows.Forms.TabPage tpgDigiTV;
		private System.Windows.Forms.CheckBox chkStart;
		private System.Windows.Forms.Label label3;
        private System.Windows.Forms.Panel pnlChannels;
		private System.Windows.Forms.ComboBox cboDigiTVChannel;
		private System.Windows.Forms.Label label2;
        private System.Windows.Forms.Label label1;
		private System.Windows.Forms.GroupBox groupBox1;
		private System.Windows.Forms.Label label5;
		private System.Windows.Forms.ComboBox cboListingsView;
		private System.Windows.Forms.GroupBox grpColours;
		private System.Windows.Forms.Label lblToday;
        private System.Windows.Forms.Label lblTomorrow;
		private System.Windows.Forms.Button btnCancel;
		DigiTVChannel dtv;
        private CheckBox chkReload;
        private Label lblNoDigiTVChannels;
        private Label lblDigiTVNotInstalled;
        private GroupBox groupBox2;
        private ComboBox cboFontName;
        private NumericUpDown nudFontSize;
        private CheckBox chkEnableStyles;
        private ToolTip toolTip1;
		private Boolean DigiTVTabLoaded=false;
        public Form1 Caller;
        private string savedFontName;
        private float savedFontSize;
        private CheckBox chkRestrictDDHeight;
        private ToolTip toolTip2;
        private Button btnTomorrow;
        private Button btnToday;
        private ColorDialog colorDialog1;
        private GroupBox groupBox3;
        private Label lblTomorrow1;
        private Label lblToday2;
        private LinkLabel lnkClearMappings;
        private bool XmlFileOpen;
        
		

		public Form3(ComboBox cbo, Form1 caller, bool xmlfileopen)
		{
			//
			// Required for Windows Form Designer support
			//
            
			InitializeComponent();
            this.Font = SystemFonts.IconTitleFont;
            SystemEvents.UserPreferenceChanged += new UserPreferenceChangedEventHandler(SystemEvents_UserPreferenceChanged);

			cboTemp=cbo;

            //cboTemp = new ComboBox();

            //for (int i = cbo.Items.Count-1; i >= 0 ; i--)
            //{
            //    cboTemp.Items.Add(cbo.Items[i]);  
            //}
            
            Caller = caller;
            XmlFileOpen = xmlfileopen;

            
			//
			// TODO: Add any constructor code after InitializeComponent call
			//
		}

        private void SystemEvents_UserPreferenceChanged(object sender, UserPreferenceChangedEventArgs e)
        {
            if (e.Category == UserPreferenceCategory.Window)
            {
                //this.Font = SystemFonts.IconTitleFont;
                this.Font = SystemFonts.DefaultFont;
            }
        }
        ~Form3()
        {
            SystemEvents.UserPreferenceChanged -= new UserPreferenceChangedEventHandler(SystemEvents_UserPreferenceChanged);


        }

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
            this.components = new System.ComponentModel.Container();
            System.ComponentModel.ComponentResourceManager resources = new System.ComponentModel.ComponentResourceManager(typeof(Form3));
            this.buttonUpdate = new System.Windows.Forms.Button();
            this.tabControl1 = new System.Windows.Forms.TabControl();
            this.tpgGeneral = new System.Windows.Forms.TabPage();
            this.chkRestrictDDHeight = new System.Windows.Forms.CheckBox();
            this.chkEnableStyles = new System.Windows.Forms.CheckBox();
            this.chkReload = new System.Windows.Forms.CheckBox();
            this.groupBox1 = new System.Windows.Forms.GroupBox();
            this.groupBox2 = new System.Windows.Forms.GroupBox();
            this.nudFontSize = new System.Windows.Forms.NumericUpDown();
            this.cboFontName = new System.Windows.Forms.ComboBox();
            this.grpColours = new System.Windows.Forms.GroupBox();
            this.groupBox3 = new System.Windows.Forms.GroupBox();
            this.lblTomorrow1 = new System.Windows.Forms.Label();
            this.lblToday2 = new System.Windows.Forms.Label();
            this.btnTomorrow = new System.Windows.Forms.Button();
            this.btnToday = new System.Windows.Forms.Button();
            this.lblTomorrow = new System.Windows.Forms.Label();
            this.lblToday = new System.Windows.Forms.Label();
            this.cboListingsView = new System.Windows.Forms.ComboBox();
            this.label5 = new System.Windows.Forms.Label();
            this.tpgDigiTV = new System.Windows.Forms.TabPage();
            this.lnkClearMappings = new System.Windows.Forms.LinkLabel();
            this.lblDigiTVNotInstalled = new System.Windows.Forms.Label();
            this.lblNoDigiTVChannels = new System.Windows.Forms.Label();
            this.chkStart = new System.Windows.Forms.CheckBox();
            this.cboDigiTVChannel = new System.Windows.Forms.ComboBox();
            this.label3 = new System.Windows.Forms.Label();
            this.pnlChannels = new System.Windows.Forms.Panel();
            this.label1 = new System.Windows.Forms.Label();
            this.label2 = new System.Windows.Forms.Label();
            this.btnCancel = new System.Windows.Forms.Button();
            this.toolTip1 = new System.Windows.Forms.ToolTip(this.components);
            this.toolTip2 = new System.Windows.Forms.ToolTip(this.components);
            this.colorDialog1 = new System.Windows.Forms.ColorDialog();
            this.tabControl1.SuspendLayout();
            this.tpgGeneral.SuspendLayout();
            this.groupBox1.SuspendLayout();
            this.groupBox2.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.nudFontSize)).BeginInit();
            this.grpColours.SuspendLayout();
            this.groupBox3.SuspendLayout();
            this.tpgDigiTV.SuspendLayout();
            this.SuspendLayout();
            // 
            // buttonUpdate
            // 
            this.buttonUpdate.FlatStyle = System.Windows.Forms.FlatStyle.System;
            this.buttonUpdate.Location = new System.Drawing.Point(184, 296);
            this.buttonUpdate.Name = "buttonUpdate";
            this.buttonUpdate.Size = new System.Drawing.Size(88, 24);
            this.buttonUpdate.TabIndex = 14;
            this.buttonUpdate.Text = "OK";
            this.buttonUpdate.Click += new System.EventHandler(this.buttonUpdate_Click);
            // 
            // tabControl1
            // 
            this.tabControl1.Controls.Add(this.tpgGeneral);
            this.tabControl1.Controls.Add(this.tpgDigiTV);
            this.tabControl1.Location = new System.Drawing.Point(8, 10);
            this.tabControl1.Name = "tabControl1";
            this.tabControl1.SelectedIndex = 0;
            this.tabControl1.Size = new System.Drawing.Size(360, 280);
            this.tabControl1.TabIndex = 15;
            this.tabControl1.SelectedIndexChanged += new System.EventHandler(this.tabControl1_SelectedIndexChanged);
            // 
            // tpgGeneral
            // 
            this.tpgGeneral.Controls.Add(this.chkRestrictDDHeight);
            this.tpgGeneral.Controls.Add(this.chkEnableStyles);
            this.tpgGeneral.Controls.Add(this.chkReload);
            this.tpgGeneral.Controls.Add(this.groupBox1);
            this.tpgGeneral.Location = new System.Drawing.Point(4, 22);
            this.tpgGeneral.Name = "tpgGeneral";
            this.tpgGeneral.Size = new System.Drawing.Size(352, 254);
            this.tpgGeneral.TabIndex = 0;
            this.tpgGeneral.Text = "";
            this.tpgGeneral.UseVisualStyleBackColor = true;
            // 
            // chkRestrictDDHeight
            // 
            this.chkRestrictDDHeight.AutoSize = true;
            this.chkRestrictDDHeight.Location = new System.Drawing.Point(8, 234);
            this.chkRestrictDDHeight.Name = "chkRestrictDDHeight";
            this.chkRestrictDDHeight.Size = new System.Drawing.Size(327, 17);
            this.chkRestrictDDHeight.TabIndex = 3;
            this.chkRestrictDDHeight.Text = "     ";
            this.toolTip2.SetToolTip(this.chkRestrictDDHeight, resources.GetString("chkRestrictDDHeight.ToolTip"));
            this.chkRestrictDDHeight.CheckedChanged += new System.EventHandler(this.chkRestrictDDHeight_CheckedChanged);
            // 
            // chkEnableStyles
            // 
            this.chkEnableStyles.AutoSize = true;
            this.chkEnableStyles.Location = new System.Drawing.Point(8, 217);
            this.chkEnableStyles.Name = "chkEnableStyles";
            this.chkEnableStyles.Size = new System.Drawing.Size(321, 17);
            this.chkEnableStyles.TabIndex = 2;
            this.chkEnableStyles.Text = "   ( ) ";
            this.toolTip1.SetToolTip(this.chkEnableStyles, resources.GetString("chkEnableStyles.ToolTip"));
            this.chkEnableStyles.CheckedChanged += new System.EventHandler(this.chkEnableStyles_CheckedChanged);
            // 
            // chkReload
            // 
            this.chkReload.AutoSize = true;
            this.chkReload.Location = new System.Drawing.Point(8, 200);
            this.chkReload.Name = "chkReload";
            this.chkReload.Size = new System.Drawing.Size(317, 17);
            this.chkReload.TabIndex = 1;
            this.chkReload.Text = "  XML-   ";
            this.chkReload.UseVisualStyleBackColor = true;
            this.chkReload.CheckedChanged += new System.EventHandler(this.chkReload_CheckedChanged);
            // 
            // groupBox1
            // 
            this.groupBox1.Controls.Add(this.groupBox2);
            this.groupBox1.Controls.Add(this.grpColours);
            this.groupBox1.Controls.Add(this.cboListingsView);
            this.groupBox1.Controls.Add(this.label5);
            this.groupBox1.Location = new System.Drawing.Point(8, 8);
            this.groupBox1.Name = "groupBox1";
            this.groupBox1.Size = new System.Drawing.Size(336, 185);
            this.groupBox1.TabIndex = 0;
            this.groupBox1.TabStop = false;
            this.groupBox1.Text = " ";
            // 
            // groupBox2
            // 
            this.groupBox2.Controls.Add(this.nudFontSize);
            this.groupBox2.Controls.Add(this.cboFontName);
            this.groupBox2.Location = new System.Drawing.Point(16, 124);
            this.groupBox2.Name = "groupBox2";
            this.groupBox2.Size = new System.Drawing.Size(304, 48);
            this.groupBox2.TabIndex = 3;
            this.groupBox2.TabStop = false;
            this.groupBox2.Text = "  ";
            // 
            // nudFontSize
            // 
            this.nudFontSize.DecimalPlaces = 2;
            this.nudFontSize.Increment = new decimal(new int[] {
            25,
            0,
            0,
            131072});
            this.nudFontSize.Location = new System.Drawing.Point(234, 19);
            this.nudFontSize.Maximum = new decimal(new int[] {
            49,
            0,
            0,
            0});
            this.nudFontSize.Minimum = new decimal(new int[] {
            5,
            0,
            0,
            0});
            this.nudFontSize.Name = "nudFontSize";
            this.nudFontSize.ReadOnly = true;
            this.nudFontSize.Size = new System.Drawing.Size(57, 21);
            this.nudFontSize.TabIndex = 3;
            this.nudFontSize.Value = new decimal(new int[] {
            2725,
            0,
            0,
            131072});
            this.nudFontSize.ValueChanged += new System.EventHandler(this.nudFontSize_ValueChanged);
            // 
            // cboFontName
            // 
            this.cboFontName.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
            this.cboFontName.Location = new System.Drawing.Point(11, 19);
            this.cboFontName.Name = "cboFontName";
            this.cboFontName.Size = new System.Drawing.Size(214, 21);
            this.cboFontName.TabIndex = 2;
            this.cboFontName.SelectedIndexChanged += new System.EventHandler(this.cboFontName_SelectedIndexChanged);
            // 
            // grpColours
            // 
            this.grpColours.Controls.Add(this.groupBox3);
            this.grpColours.Controls.Add(this.btnTomorrow);
            this.grpColours.Controls.Add(this.btnToday);
            this.grpColours.Controls.Add(this.lblTomorrow);
            this.grpColours.Controls.Add(this.lblToday);
            this.grpColours.Location = new System.Drawing.Point(16, 43);
            this.grpColours.Name = "grpColours";
            this.grpColours.Size = new System.Drawing.Size(304, 76);
            this.grpColours.TabIndex = 2;
            this.grpColours.TabStop = false;
            this.grpColours.Text = "   ";
            // 
            // groupBox3
            // 
            this.groupBox3.BackColor = System.Drawing.SystemColors.Window;
            this.groupBox3.Controls.Add(this.lblTomorrow1);
            this.groupBox3.Controls.Add(this.lblToday2);
            this.groupBox3.Location = new System.Drawing.Point(176, 11);
            this.groupBox3.Name = "groupBox3";
            this.groupBox3.Size = new System.Drawing.Size(119, 56);
            this.groupBox3.TabIndex = 5;
            this.groupBox3.TabStop = false;
            this.groupBox3.Text = "";
            // 
            // lblTomorrow1
            // 
            this.lblTomorrow1.Location = new System.Drawing.Point(9, 34);
            this.lblTomorrow1.Name = "lblTomorrow1";
            this.lblTomorrow1.Size = new System.Drawing.Size(106, 16);
            this.lblTomorrow1.TabIndex = 4;
            this.lblTomorrow1.Text = " ";
            // 
            // lblToday2
            // 
            this.lblToday2.Location = new System.Drawing.Point(9, 18);
            this.lblToday2.Name = "lblToday2";
            this.lblToday2.Size = new System.Drawing.Size(101, 16);
            this.lblToday2.TabIndex = 3;
            this.lblToday2.Text = " ";
            // 
            // btnTomorrow
            // 
            this.btnTomorrow.BackColor = System.Drawing.Color.Maroon;
            this.btnTomorrow.Location = new System.Drawing.Point(73, 44);
            this.btnTomorrow.Name = "btnTomorrow";
            this.btnTomorrow.Size = new System.Drawing.Size(95, 23);
            this.btnTomorrow.TabIndex = 4;
            this.btnTomorrow.UseVisualStyleBackColor = false;
            this.btnTomorrow.Click += new System.EventHandler(this.btnToday_Click);
            // 
            // btnToday
            // 
            this.btnToday.BackColor = System.Drawing.Color.Maroon;
            this.btnToday.Location = new System.Drawing.Point(73, 19);
            this.btnToday.Name = "btnToday";
            this.btnToday.Size = new System.Drawing.Size(95, 23);
            this.btnToday.TabIndex = 3;
            this.btnToday.UseVisualStyleBackColor = false;
            this.btnToday.Click += new System.EventHandler(this.btnToday_Click);
            // 
            // lblTomorrow
            // 
            this.lblTomorrow.Location = new System.Drawing.Point(8, 48);
            this.lblTomorrow.Name = "lblTomorrow";
            this.lblTomorrow.Size = new System.Drawing.Size(56, 16);
            this.lblTomorrow.TabIndex = 1;
            this.lblTomorrow.Text = "";
            this.lblTomorrow.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // lblToday
            // 
            this.lblToday.Location = new System.Drawing.Point(8, 24);
            this.lblToday.Name = "lblToday";
            this.lblToday.Size = new System.Drawing.Size(50, 16);
            this.lblToday.TabIndex = 0;
            this.lblToday.Text = "";
            this.lblToday.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // cboListingsView
            // 
            this.cboListingsView.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
            this.cboListingsView.Items.AddRange(new object[] {
            " ",
            "  "});
            this.cboListingsView.Location = new System.Drawing.Point(152, 16);
            this.cboListingsView.Name = "cboListingsView";
            this.cboListingsView.Size = new System.Drawing.Size(168, 21);
            this.cboListingsView.TabIndex = 1;
            this.cboListingsView.SelectedIndexChanged += new System.EventHandler(this.cboListingsView_SelectedIndexChanged);
            // 
            // label5
            // 
            this.label5.Location = new System.Drawing.Point(16, 20);
            this.label5.Name = "label5";
            this.label5.Size = new System.Drawing.Size(136, 16);
            this.label5.TabIndex = 0;
            this.label5.Text = " ";
            // 
            // tpgDigiTV
            // 
            this.tpgDigiTV.Controls.Add(this.lnkClearMappings);
            this.tpgDigiTV.Controls.Add(this.lblDigiTVNotInstalled);
            this.tpgDigiTV.Controls.Add(this.lblNoDigiTVChannels);
            this.tpgDigiTV.Controls.Add(this.chkStart);
            this.tpgDigiTV.Controls.Add(this.cboDigiTVChannel);
            this.tpgDigiTV.Controls.Add(this.label3);
            this.tpgDigiTV.Controls.Add(this.pnlChannels);
            this.tpgDigiTV.Controls.Add(this.label1);
            this.tpgDigiTV.Controls.Add(this.label2);
            this.tpgDigiTV.Location = new System.Drawing.Point(4, 22);
            this.tpgDigiTV.Name = "tpgDigiTV";
            this.tpgDigiTV.Size = new System.Drawing.Size(352, 254);
            this.tpgDigiTV.TabIndex = 1;
            this.tpgDigiTV.Text = "DigiTV Settings";
            this.tpgDigiTV.UseVisualStyleBackColor = true;
            // 
            // lnkClearMappings
            // 
            this.lnkClearMappings.AutoSize = true;
            this.lnkClearMappings.Location = new System.Drawing.Point(262, 233);
            this.lnkClearMappings.Name = "lnkClearMappings";
            this.lnkClearMappings.Size = new System.Drawing.Size(80, 13);
            this.lnkClearMappings.TabIndex = 28;
            this.lnkClearMappings.TabStop = true;
            this.lnkClearMappings.Text = "Clear Mappings";
            this.lnkClearMappings.LinkClicked += new System.Windows.Forms.LinkLabelLinkClickedEventHandler(this.lnkClearMappings_LinkClicked);
            // 
            // lblDigiTVNotInstalled
            // 
            this.lblDigiTVNotInstalled.ForeColor = System.Drawing.Color.Red;
            this.lblDigiTVNotInstalled.Location = new System.Drawing.Point(56, 109);
            this.lblDigiTVNotInstalled.Name = "lblDigiTVNotInstalled";
            this.lblDigiTVNotInstalled.Size = new System.Drawing.Size(240, 37);
            this.lblDigiTVNotInstalled.TabIndex = 27;
            this.lblDigiTVNotInstalled.Text = "DigiTV is not installed on this machine.";
            this.lblDigiTVNotInstalled.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
            // 
            // lblNoDigiTVChannels
            // 
            this.lblNoDigiTVChannels.ForeColor = System.Drawing.Color.Red;
            this.lblNoDigiTVChannels.Location = new System.Drawing.Point(56, 87);
            this.lblNoDigiTVChannels.Name = "lblNoDigiTVChannels";
            this.lblNoDigiTVChannels.Size = new System.Drawing.Size(240, 80);
            this.lblNoDigiTVChannels.TabIndex = 26;
            this.lblNoDigiTVChannels.Text = "There appear to be no DigiTV channels stored on your system. This could be becaus" +
                "e the card hasn\'t yet been tuned in.  Check that the card has been tuned in and " +
                "try again.";
            // 
            // chkStart
            // 
            this.chkStart.BackColor = System.Drawing.Color.Transparent;
            this.chkStart.Location = new System.Drawing.Point(10, 232);
            this.chkStart.Name = "chkStart";
            this.chkStart.Size = new System.Drawing.Size(240, 16);
            this.chkStart.TabIndex = 22;
            this.chkStart.Text = "Start DigiTV on exit after setting a timer";
            this.chkStart.UseVisualStyleBackColor = false;
            this.chkStart.CheckedChanged += new System.EventHandler(this.chkStart_CheckedChanged);
            // 
            // cboDigiTVChannel
            // 
            this.cboDigiTVChannel.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
            this.cboDigiTVChannel.ItemHeight = 13;
            this.cboDigiTVChannel.Location = new System.Drawing.Point(182, 205);
            this.cboDigiTVChannel.Name = "cboDigiTVChannel";
            this.cboDigiTVChannel.Size = new System.Drawing.Size(160, 21);
            this.cboDigiTVChannel.TabIndex = 23;
            this.cboDigiTVChannel.Visible = false;
            this.cboDigiTVChannel.SelectedIndexChanged += new System.EventHandler(this.cboDigiTVChannel_SelectedIndexChanged);
            // 
            // label3
            // 
            this.label3.Location = new System.Drawing.Point(8, 184);
            this.label3.Name = "label3";
            this.label3.Size = new System.Drawing.Size(320, 40);
            this.label3.TabIndex = 21;
            this.label3.Text = "Match up the Radio Times channel names with their corresponding DigiTV channel na" +
                "mes";
            // 
            // pnlChannels
            // 
            this.pnlChannels.AutoScroll = true;
            this.pnlChannels.Location = new System.Drawing.Point(8, 24);
            this.pnlChannels.Name = "pnlChannels";
            this.pnlChannels.Size = new System.Drawing.Size(334, 154);
            this.pnlChannels.TabIndex = 18;
            // 
            // label1
            // 
            this.label1.Location = new System.Drawing.Point(8, 8);
            this.label1.Name = "label1";
            this.label1.Size = new System.Drawing.Size(152, 16);
            this.label1.TabIndex = 19;
            this.label1.Text = "Radio Times Channels";
            // 
            // label2
            // 
            this.label2.Location = new System.Drawing.Point(164, 8);
            this.label2.Name = "label2";
            this.label2.Size = new System.Drawing.Size(155, 16);
            this.label2.TabIndex = 20;
            this.label2.Text = "DigiTV Channels";
            // 
            // btnCancel
            // 
            this.btnCancel.FlatStyle = System.Windows.Forms.FlatStyle.System;
            this.btnCancel.Location = new System.Drawing.Point(280, 296);
            this.btnCancel.Name = "btnCancel";
            this.btnCancel.Size = new System.Drawing.Size(88, 24);
            this.btnCancel.TabIndex = 16;
            this.btnCancel.Text = "";
            this.btnCancel.Click += new System.EventHandler(this.btnCancel_Click);
            // 
            // toolTip1
            // 
            this.toolTip1.AutomaticDelay = 1000;
            this.toolTip1.IsBalloon = true;
            this.toolTip1.ShowAlways = true;
            this.toolTip1.ToolTipIcon = System.Windows.Forms.ToolTipIcon.Info;
            this.toolTip1.ToolTipTitle = " ";
            // 
            // toolTip2
            // 
            this.toolTip2.AutomaticDelay = 1000;
            this.toolTip2.IsBalloon = true;
            this.toolTip2.ShowAlways = true;
            this.toolTip2.ToolTipIcon = System.Windows.Forms.ToolTipIcon.Info;
            this.toolTip2.ToolTipTitle = " ";
            // 
            // Form3
            // 
            this.AutoScaleBaseSize = new System.Drawing.Size(5, 14);
            this.ClientSize = new System.Drawing.Size(376, 327);
            this.ControlBox = false;
            this.Controls.Add(this.btnCancel);
            this.Controls.Add(this.tabControl1);
            this.Controls.Add(this.buttonUpdate);
            this.Font = new System.Drawing.Font("Tahoma", 8.25F);
            this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedDialog;
            this.MaximizeBox = false;
            this.MinimizeBox = false;
            this.Name = "Form3";
            this.ShowInTaskbar = false;
            this.StartPosition = System.Windows.Forms.FormStartPosition.CenterParent;
            this.Text = "";
            this.Load += new System.EventHandler(this.Form3_Load);
            this.tabControl1.ResumeLayout(false);
            this.tpgGeneral.ResumeLayout(false);
            this.tpgGeneral.PerformLayout();
            this.groupBox1.ResumeLayout(false);
            this.groupBox2.ResumeLayout(false);
            ((System.ComponentModel.ISupportInitialize)(this.nudFontSize)).EndInit();
            this.grpColours.ResumeLayout(false);
            this.groupBox3.ResumeLayout(false);
            this.tpgDigiTV.ResumeLayout(false);
            this.tpgDigiTV.PerformLayout();
            this.ResumeLayout(false);

		}
		#endregion

//		[System.Runtime.InteropServices.DllImport("kernel32.dll", SetLastError=true)] 
//		static extern int CreateFileMappingA  ( int hFile, ref SECURITY_ATTRIBUTES lpFileMappigAttributes,  int flProtect,  int dwMaximumSizeHigh,  int dwMaximumSizeLow,  string  lpName);

		[System.Runtime.InteropServices.DllImport("user32.dll")] 
		static extern IntPtr SetActiveWindow(IntPtr hWnd);

		[System.Runtime.InteropServices.DllImport("User32.Dll")]
		static extern IntPtr SendMessage(int hWnd, uint Msg, int wParam, int lParam);

		[System.Runtime.InteropServices.DllImport("user32.dll")] 
		public static extern int FindWindow (string className, string windowName);




		
		

		public void LoadControls()
		{

            pnlChannels.Controls.Clear();
            pnlChannels.Refresh();
            label1.Visible = false;
            label2.Visible = false;
            label3.Text = "Retrieving channel mappings. Please wait...";
            
            tabControl1.Enabled = false;
            lblNoDigiTVChannels.Visible = false;
            lblDigiTVNotInstalled.Visible = false;

            tabControl1.Refresh();
			
			RegistryKey mapkey=Registry.CurrentUser.CreateSubKey(@"Software\XMLTV EPG Viewer\ChannelMappings");
			if (mapkey.SubKeyCount==0)
			{
				NoChannelsMapped=true;
			}
			else
			{
				NoChannelsMapped=false;
			}
			
			RegistryKey key=Registry.LocalMachine.OpenSubKey(@"Software\Nebula\DigiTV\Channels");
			if (key!=null)
			{
				string[] arrChannel=key.GetSubKeyNames();
			

				dtv=new DigiTVChannel();
				dtv.LCN=0;
				dtv.Freq="0";
				dtv.ChannelName="[No match]";
                cboDigiTVChannel.Items.Clear();
				cboDigiTVChannel.Items.Add(dtv);

				MyListBoxItem rt=new MyListBoxItem();

				foreach(string strChannel in arrChannel)
				{
					key=Registry.LocalMachine.OpenSubKey(@"Software\Nebula\DigiTV\Channels\" + strChannel);
					string strType=key.GetValue("Type").ToString();
					byte[] byt=(System.Byte[])key.GetValue("LCN");
					int intLCN=General.BinaryToInt(byt);
					string strFreq=key.GetValue("Frequency").ToString();

                    if (strType.Substring(0, 2) == "TV" || strType == "Radio")
					{
						dtv.ChannelName=strChannel;
						dtv.LCN=intLCN;
						dtv.Freq=strFreq;

						cboDigiTVChannel.Items.Add(dtv);
					}
				}
				int intNextTop=0;

				for(int n=0;n<=cboTemp.Items.Count-1;n++)
				{
					TextBox txtRT = new TextBox();
					txtRT.TabStop=false;
					txtRT.AutoSize=false;
					//txtRT.BorderStyle=BorderStyle.Fixed3D;
					txtRT.Name="txtRTChannel" + n.ToString();
					txtRT.ReadOnly=true;
					txtRT.BackColor=SystemColors.Window;
			
					txtRT.Left=3;
					txtRT.Width=label1.Width;
			
					if (n==0)
					{
						txtRT.Top=4;
					}
					else
					{
						txtRT.Top=intNextTop;
					}
			
					rt=(MyListBoxItem)cboTemp.Items[n];
					txtRT.Text=rt.itemText;
					txtRT.Tag=rt.itemData;
			

					ComboBox cboDig = new  ComboBox();
                    
					cboDig.Name="cboDigiTVChannel" + n.ToString();
					cboDig.Sorted=false;
					for(int m=0;m<=cboDigiTVChannel.Items.Count-1;m++)
					{
						cboDig.Items.Add(cboDigiTVChannel.Items[m]);
					}
                    
                    txtRT.Height=cboDigiTVChannel.Height;
					cboDig.Top=txtRT.Top;
					
                    //txtRT.Height = cboDig.Height;
					cboDig.DropDownStyle=System.Windows.Forms.ComboBoxStyle.DropDownList;
					cboDig.Left=txtRT.Left+txtRT.Width+4;
					cboDig.Width=label2.Width;

					string strChannel;
					int index=-1;

					if(NoChannelsMapped)
					{
						strChannel = txtRT.Text.Replace("BBC1", "BBC ONE");
                        strChannel = strChannel.Replace("BBC2 Wales Digital", "BBC 2W");
						strChannel = strChannel.Replace("BBC2", "BBC TWO");
						strChannel = strChannel.Replace("BBC3", "BBC THREE");
						strChannel = strChannel.Replace("BBC4", "BBC FOUR");
                        strChannel = strChannel.Replace("More4", "More 4");
                        strChannel = strChannel.Replace("Ftn", "f tn");
                        strChannel = strChannel.Replace("S4C Digital", "S4C");
					}
					else
					{
						RegistryKey currkey=Registry.CurrentUser.OpenSubKey(@"Software\XMLTV EPG Viewer\ChannelMappings");
						try
						{
							RegistryKey currmapkey=currkey.OpenSubKey(txtRT.Tag.ToString());
							strChannel=currmapkey.GetValue("DigiName").ToString();
						}
						catch (Exception)
						{
							strChannel="";
							index=-1;
						}
					}
					index=cboDig.FindString(strChannel);
					if(index==-1)
					{
						cboDig.SelectedIndex=0;
					}
					else
					{
						cboDig.SelectedIndex=index;
					}
                    //this.Text = txtRT.Height.ToString() + " " + cboDig.Height.ToString();

                    txtRT.Visible = false;
                    cboDig.Visible = false;

                    pnlChannels.Controls.Add (txtRT);
					cboDig.SelectedIndexChanged += new System.EventHandler(this.cboDigiTVChannel_SelectedIndexChanged);
					pnlChannels.Controls.Add (cboDig);

					intNextTop=txtRT.Top+txtRT.Height+4;
					NoChannelsTuned=false;
				}
                
			}
			else
			{
				NoChannelsTuned=true;
			}
            //pnlChannels.Visible = true;
			//pnlChannels.ResumeLayout();
			if(NoChannelsMapped)
			{
				label3.Text="No channels mappings have yet been saved. The ones above are the closest matches. Check the mappings, make any changes necessary, and click OK.";
				buttonUpdate.Enabled=true;
                tpgDigiTV.Tag = true;
			}
			else
			{
				label3.Text="These are your current channel mappings. If necessary, make any changes and click OK.";
				
			}

            if (NoChannelsTuned)
            {
                label1.Visible = false;
                label2.Visible=false;
                label3.Visible=false;
                lblNoDigiTVChannels.Visible = true;
                chkStart.Visible = false;
                pnlChannels.Visible = true;
            }
            else
            {
                
                foreach (Control ctl in pnlChannels.Controls)
                {
                    ctl.Visible = true;
                }
                
                pnlChannels.Visible = true;
                lblNoDigiTVChannels.Visible = false;
                pnlChannels.Visible = true;
                label1.Visible = true;
                label2.Visible = true;

            }
            
            tabControl1.Enabled = true;
            

		}

		private void cboDigiTVChannel_SelectedIndexChanged(object sender, System.EventArgs e)
		{
            tpgDigiTV.Tag = true;
            buttonUpdate.Enabled=true;
		}

		private void buttonUpdate_Click(object sender, System.EventArgs e)
		{
			RegistryKey key = Registry.CurrentUser.CreateSubKey(@"Software\XMLTV EPG Viewer");
			RegistryKey subkey;
            if ((bool)tpgDigiTV.Tag == true)
            {
                subkey = key.OpenSubKey("ChannelMappings");
                if (subkey != null)
                    key.DeleteSubKeyTree("ChannelMappings");
                subkey = key.CreateSubKey("ChannelMappings");

                TextBox txtRT;
                ComboBox cboDigi;

                Hashtable ht = new Hashtable();
                for (int n = 0; n <= pnlChannels.Controls.Count - 1; n++)
                {
                    ht.Add(pnlChannels.Controls[n].Name, pnlChannels.Controls[n]);
                }

                for (int n = 0; n <= (ht.Count / 2- 1) ; n++)
                {
                    txtRT = (TextBox)ht["txtRTChannel" + n.ToString()];
                    cboDigi = (ComboBox)ht["cboDigiTVChannel" + n.ToString()];
                    dtv = (DigiTVChannel)cboDigi.SelectedItem;

                    RegistryKey skey = subkey.CreateSubKey(txtRT.Tag.ToString());
                    skey.SetValue("RTName", txtRT.Text);
                    skey.SetValue("DigiID", dtv.LCN);
                    skey.SetValue("DigiName", dtv.ChannelName);
                    skey.SetValue("DigiFreq", dtv.Freq);
                    skey.Close();
                }
                subkey.Close();
            }
            if (cboListingsView.SelectedIndex == 0)
            {
                General.Twenty4HourView = false;
            }
            else
            {
                General.Twenty4HourView = true;
            }

            General.bStartDigiTV=chkStart.Checked;
            General.todayColour = btnToday.BackColor;
            General.tomorrowColour = btnTomorrow.BackColor;
            General.LoadLastFile = chkReload.Checked;
            General.EnableVisualStyles = chkEnableStyles.Checked;
            General.RestrictDropdownHeight = chkRestrictDDHeight.Checked;
            

            key = Registry.CurrentUser.CreateSubKey(@"Software\XMLTV EPG Viewer");
            key.SetValue("24HourView", General.Twenty4HourView);
            key.SetValue("StartDigiTV", General.bStartDigiTV);
            key.SetValue("TodayColour", General.todayColour.ToArgb().ToString());
            key.SetValue("TomorrowColour", General.tomorrowColour.ToArgb().ToString());
            key.SetValue("LoadLastFile", General.LoadLastFile);
            key.SetValue("FontName", General.FontName);
            key.SetValue("FontSize", General.FontSize);
            key.SetValue("EnableVisualStyles", General.EnableVisualStyles);
            key.SetValue("RestrictDropDownHeight", General.RestrictDropdownHeight);
            
            DialogResult = DialogResult.OK;

            key.Close();

		}


		private void Form3_Load(object sender, System.EventArgs e)
		{

            savedFontName = General.FontName;
            savedFontSize = General.FontSize;

			lblNoDigiTVChannels.Visible=false;
            chkReload.Checked = General.LoadLastFile;
            chkStart.Checked = General.bStartDigiTV;
            chkEnableStyles.Checked = General.EnableVisualStyles;
            chkRestrictDDHeight.Checked = General.RestrictDropdownHeight;
            
            lblToday2.ForeColor = General.todayColour;
			lblTomorrow1.ForeColor=General.tomorrowColour;
            btnToday.BackColor=General.todayColour;
            btnTomorrow.BackColor=General.tomorrowColour;

            InstalledFontCollection fonts = new InstalledFontCollection();
            foreach (FontFamily family in fonts.Families)
            {
                if(family.IsStyleAvailable(FontStyle.Regular))
                    cboFontName.Items.Add(family.GetName(0));
            }

            int f = cboFontName.FindString(General.FontName);
            cboFontName.SelectedIndex = f;

            nudFontSize.Value = (decimal)General.FontSize;

            if (General.Twenty4HourView)
            {
                cboListingsView.SelectedIndex = 1;
            }
            else
            {
                cboListingsView.SelectedIndex = 0;
            }
            buttonUpdate.Enabled = false;
            tpgGeneral.Tag = false;
            tpgDigiTV.Tag = false;
            General.RefreshNeeded = false;
		}

		private void chkStart_CheckedChanged(object sender, System.EventArgs e)
		{
            tpgDigiTV.Tag = true;
            buttonUpdate.Enabled = true;
		}

		private void btnCancel_Click(object sender, System.EventArgs e)
		{
            General.FontName = savedFontName;
            General.FontSize = savedFontSize;

            DialogResult = DialogResult.Cancel;
		}

		private void tabControl1_SelectedIndexChanged(object sender, System.EventArgs e)
		{
            
            tabControl1.Refresh();

            if (tabControl1.SelectedTab==tpgDigiTV)
			{
                
                if (General.bDigiTVInstalled)
                {
                    if(XmlFileOpen)
                    {
                        if (!DigiTVTabLoaded)
                        {
                            Cursor = Cursors.WaitCursor;
                            pnlChannels.Visible = false;
                            pnlChannels.Refresh();
                            LoadControls();
                            DigiTVTabLoaded = true;
                            Cursor = Cursors.Default;

                        }
                    }
                    else
                    {
                        foreach (Control ctl in tpgDigiTV.Controls)
                        {
                            ctl.Visible = false;
                        }
                        foreach (Control ctl in pnlChannels.Controls)
                        {
                            ctl.Visible = false;
                        }
                        lblDigiTVNotInstalled.Text = "Please load a listings file to view your channel mappings.";
                        lblDigiTVNotInstalled.Visible = true;
                    }
                }
                else
                {
                    foreach (Control ctl in tpgDigiTV.Controls)
                    {
                        ctl.Visible = false;
                    }
                    foreach (Control ctl in pnlChannels.Controls)
                    {
                        ctl.Visible = false;
                    }
                    lblDigiTVNotInstalled.Visible = true;
                }
			}
			
		}

        private void chkReload_CheckedChanged(object sender, EventArgs e)
        {
            tpgGeneral.Tag = true;
            buttonUpdate.Enabled = true;
        }

        private void cboListingsView_SelectedIndexChanged(object sender, EventArgs e)
        {
            tpgGeneral.Tag = true;
            buttonUpdate.Enabled = true;
            General.RefreshNeeded = true;
        }

        

        private void cboFontName_SelectedIndexChanged(object sender, EventArgs e)
        {
            General.FontName = cboFontName.SelectedItem.ToString();
            buttonUpdate.Enabled = true;
            General.FontChanged=true;
            Caller.SizeControls();
            Caller.SizeListViews();
            //Caller.Refresh();
        }

        private void nudFontSize_ValueChanged(object sender, EventArgs e)
        {
            General.FontSize = (float) nudFontSize.Value;
            buttonUpdate.Enabled = true;
            General.FontChanged = true;
            //this.Font = new Font(General.FontName, General.FontSize);
            Caller.SizeControls();
            Caller.SizeListViews();
            //Caller.Refresh();
            
        }

        private void chkEnableStyles_CheckedChanged(object sender, EventArgs e)
        {
            //MessageBoxEx.Show("This will take effect the next time the Viewer is run.", "Requires restart", MessageBoxButtons.OK, MessageBoxIcon.Information);
            tpgGeneral.Tag = true;
            buttonUpdate.Enabled = true;
        }

        private void chkRestrictDDHeight_CheckedChanged(object sender, EventArgs e)
        {
            tpgGeneral.Tag = true;
            buttonUpdate.Enabled = true;
        }

        private void btnToday_Click(object sender, EventArgs e)
        {
            DialogResult res =  colorDialog1.ShowDialog(this);
            if (res == DialogResult.OK)
            {
                Button btn = (Button)sender;
                btn.BackColor = colorDialog1.Color;
                lblToday2.ForeColor = btnToday.BackColor;
                lblTomorrow1.ForeColor = btnTomorrow.BackColor;
                tpgGeneral.Tag = true;
                buttonUpdate.Enabled = true;
                General.RefreshNeeded = true;
            }
        }

        private void lnkClearMappings_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
        {
            DialogResult res = MessageBoxEx.Show(this, "Are you sure you want to clear your channel mappings?", "Confirm Clear", MessageBoxButtons.YesNo, MessageBoxIcon.Question, MessageBoxDefaultButton.Button2);
            if (res == DialogResult.Yes)
            {
                try
                {
                    Registry.CurrentUser.DeleteSubKeyTree(@"Software\XMLTV EPG Viewer\ChannelMappings");
                    this.Cursor = Cursors.WaitCursor;
                    pnlChannels.Visible = false;
                    pnlChannels.Refresh();
                    LoadControls();
                    //DigiTVTabLoaded = true;
                    this.Cursor = Cursors.Default;
                }
                catch (Exception ex)
                {
                    MessageBoxEx.Show(this, "Unable to clear channel mappings. " + ex.Message, "Error", MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
                }
                finally {this.Cursor = Cursors.Default;}
            }
        }
	}
}
