using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
using System.Xml;
using System.IO;
using Microsoft.Win32;
using System.Diagnostics;
using Utils;
using System.Drawing.Text;
//using System.Drawing;


namespace epgviewer
{
	/// <summary>
	/// Summary description for Form1.
	/// </summary>
    public partial class Form1 : System.Windows.Forms.Form, IMRUClient
    {
        private MRUManager mruManager;
        public void OpenMRUFile(string File)
        {
            OpenXMLFile(File);
        }
        private const int LVM_GETCOUNTPERPAGE = 0x1000 + 40;
        private const int LVS_EX_DOUBLEBUFFER = 0x00010000;
        //private const int WM_DISPLAYCHANGE = 126;
        private System.Xml.XmlDocument m_xmldoc;
        private System.Windows.Forms.MenuItem menuItem13;
        private System.Windows.Forms.MainMenu mainMenu1;
        private System.Windows.Forms.Panel pnlTop;
        private System.Windows.Forms.Panel pnlMid;
        private System.Windows.Forms.Splitter splitter1;
        private System.Windows.Forms.ListView lvw1;
        private System.Windows.Forms.ColumnHeader columnHeader1;
        private System.Windows.Forms.ColumnHeader columnHeader2;
        private System.Windows.Forms.Panel panel1;
        public System.Windows.Forms.ComboBox cboChannel;
        private System.Windows.Forms.TextBox textBox1;
        private System.Windows.Forms.ComboBox cboDay;
        public System.Windows.Forms.StatusBar sbr1;
        private System.ComponentModel.IContainer components;
        private bool bLoading = false;
        private string strCurrentFile = "";
        private System.Windows.Forms.OpenFileDialog dlgOpen;
        private System.Windows.Forms.MenuItem mnuFile;
        private System.Windows.Forms.MenuItem mnuFileOpen;
        private System.Windows.Forms.MenuItem mnuExit;
        private System.Windows.Forms.MenuItem mnuHelp;
        private System.Windows.Forms.MenuItem mnuAbout;
        private System.Windows.Forms.ColumnHeader columnHeader3;
        private string strFileNameOnly = "";
        private string FileToLoad = "";
        private System.Windows.Forms.MenuItem mnuSettings;
        private System.Windows.Forms.ContextMenu contextMenu1;
        private int intVSWidth = System.Windows.Forms.SystemInformation.VerticalScrollBarWidth;

        int workingareaheight;
        float fontheight;
        int dropitems;


        //		struct SECURITY_ATTRIBUTES
        //		{
        //			int nLength;
        //			int lpSecurityDescriptor;
        //			int bInheritHandle;
        //		}
        const int PAGE_READONLY = 2;
        const int WM_SYSCOMMAND = 0x0112;
        private System.Windows.Forms.MenuItem mnuSetTimer;
        private System.Windows.Forms.ListView lvwSearch;
        private System.Windows.Forms.TextBox txtDescSearch;
        private System.Windows.Forms.Button btnSearch;
        private System.Windows.Forms.TextBox txtSearch;
        private System.Windows.Forms.ColumnHeader programme;
        private System.Windows.Forms.ColumnHeader date;
        private System.Windows.Forms.MenuItem menuItem2;
        private System.Windows.Forms.MenuItem mnuListingsView;
        private System.Windows.Forms.MenuItem mnuSearchView;
        private MenuItem menuItem1;
        private StatusBarPanel statusBarPanel1;
        private BackgroundWorker backgroundWorker1;
        private MenuItem menuItem3;
        private MenuItem mnuFileMRU;
        const int SC_CLOSE = 0xF060;




        public Form1()
        {
            //
            // Required for Windows Form Designer support
            //
            InitializeComponent();
           //

        }
        

        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                if (components != null)
                {
                    components.Dispose();
                }
            }
            base.Dispose(disposing);
        }

        #region Windows Form Designer generated code
        /// <summary>
        /// Required method for Designer support - do not modify
        /// the contents of this method with the code editor.
        /// </summary>
        private void InitializeComponent()
        {
            this.components = new System.ComponentModel.Container();
            System.ComponentModel.ComponentResourceManager resources = new System.ComponentModel.ComponentResourceManager(typeof(Form1));
            this.pnlTop = new System.Windows.Forms.Panel();
            this.mnuFile = new System.Windows.Forms.MenuItem();
            this.mnuFileOpen = new System.Windows.Forms.MenuItem();
            this.menuItem3 = new System.Windows.Forms.MenuItem();
            this.mnuFileMRU = new System.Windows.Forms.MenuItem();
            this.menuItem13 = new System.Windows.Forms.MenuItem();
            this.mnuExit = new System.Windows.Forms.MenuItem();
            this.mnuSettings = new System.Windows.Forms.MenuItem();
            this.mnuHelp = new System.Windows.Forms.MenuItem();
            this.mnuAbout = new System.Windows.Forms.MenuItem();
            this.mainMenu1 = new System.Windows.Forms.MainMenu(this.components);
            this.menuItem2 = new System.Windows.Forms.MenuItem();
            this.mnuListingsView = new System.Windows.Forms.MenuItem();
            this.mnuSearchView = new System.Windows.Forms.MenuItem();
            this.menuItem1 = new System.Windows.Forms.MenuItem();
            this.cboChannel = new System.Windows.Forms.ComboBox();
            this.cboDay = new System.Windows.Forms.ComboBox();
            this.pnlMid = new System.Windows.Forms.Panel();
            this.lvw1 = new System.Windows.Forms.ListView();
            this.columnHeader1 = new System.Windows.Forms.ColumnHeader();
            this.columnHeader2 = new System.Windows.Forms.ColumnHeader();
            this.columnHeader3 = new System.Windows.Forms.ColumnHeader();
            this.contextMenu1 = new System.Windows.Forms.ContextMenu();
            this.mnuSetTimer = new System.Windows.Forms.MenuItem();
            this.lvwSearch = new System.Windows.Forms.ListView();
            this.programme = new System.Windows.Forms.ColumnHeader();
            this.date = new System.Windows.Forms.ColumnHeader();
            this.splitter1 = new System.Windows.Forms.Splitter();
            this.sbr1 = new System.Windows.Forms.StatusBar();
            this.statusBarPanel1 = new System.Windows.Forms.StatusBarPanel();
            this.panel1 = new System.Windows.Forms.Panel();
            this.txtDescSearch = new System.Windows.Forms.TextBox();
            this.textBox1 = new System.Windows.Forms.TextBox();
            this.dlgOpen = new System.Windows.Forms.OpenFileDialog();
            this.btnSearch = new System.Windows.Forms.Button();
            this.txtSearch = new System.Windows.Forms.TextBox();
            this.backgroundWorker1 = new System.ComponentModel.BackgroundWorker();
            this.pnlMid.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.statusBarPanel1)).BeginInit();
            this.panel1.SuspendLayout();
            this.SuspendLayout();
            // 
            // pnlTop
            // 
            this.pnlTop.Dock = System.Windows.Forms.DockStyle.Top;
            this.pnlTop.Location = new System.Drawing.Point(0, 0);
            this.pnlTop.Name = "pnlTop";
            this.pnlTop.Padding = new System.Windows.Forms.Padding(5, 0, 5, 0);
            this.pnlTop.Size = new System.Drawing.Size(252, 30);
            this.pnlTop.TabIndex = 1;
            // 
            // mnuFile
            // 
            this.mnuFile.Index = 0;
            this.mnuFile.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
            this.mnuFileOpen,
            this.menuItem3,
            this.mnuFileMRU,
            this.menuItem13,
            this.mnuExit});
            this.mnuFile.Text = "";
            // 
            // mnuFileOpen
            // 
            this.mnuFileOpen.Index = 0;
            this.mnuFileOpen.Text = " XML-...";
            this.mnuFileOpen.Click += new System.EventHandler(this.mnuFileOpen_Click);
            // 
            // menuItem3
            // 
            this.menuItem3.Index = 1;
            this.menuItem3.Text = "-";
            // 
            // mnuFileMRU
            // 
            this.mnuFileMRU.Index = 2;
            this.mnuFileMRU.Text = " ";
            // 
            // menuItem13
            // 
            this.menuItem13.Index = 3;
            this.menuItem13.Text = "-";
            // 
            // mnuExit
            // 
            this.mnuExit.Index = 4;
            this.mnuExit.Text = "";
            this.mnuExit.Click += new System.EventHandler(this.mnuExit_Click);
            // 
            // mnuSettings
            // 
            this.mnuSettings.Index = 3;
            this.mnuSettings.Text = "...";
            this.mnuSettings.Click += new System.EventHandler(this.mnuSettings_Click);
            // 
            // mnuHelp
            // 
            this.mnuHelp.Index = 2;
            this.mnuHelp.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
            this.mnuAbout});
            this.mnuHelp.Text = "";
            // 
            // mnuAbout
            // 
            this.mnuAbout.Index = 0;
            this.mnuAbout.Text = " ";
            this.mnuAbout.Click += new System.EventHandler(this.mnuAbout_Click);
            // 
            // mainMenu1
            // 
            this.mainMenu1.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
            this.mnuFile,
            this.menuItem2,
            this.mnuHelp});
            // 
            // menuItem2
            // 
            this.menuItem2.Index = 1;
            this.menuItem2.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
            this.mnuListingsView,
            this.mnuSearchView,
            this.menuItem1,
            this.mnuSettings});
            this.menuItem2.Text = "";
            // 
            // mnuListingsView
            // 
            this.mnuListingsView.Index = 0;
            this.mnuListingsView.Shortcut = System.Windows.Forms.Shortcut.CtrlL;
            this.mnuListingsView.Text = "";
            this.mnuListingsView.Click += new System.EventHandler(this.mnuListingsView_Click);
            // 
            // mnuSearchView
            // 
            this.mnuSearchView.Index = 1;
            this.mnuSearchView.Shortcut = System.Windows.Forms.Shortcut.CtrlS;
            this.mnuSearchView.Text = "...";
            this.mnuSearchView.Click += new System.EventHandler(this.mnuSearchView_Click);
            // 
            // menuItem1
            // 
            this.menuItem1.Index = 2;
            this.menuItem1.Text = "-";
            // 
            // cboChannel
            // 
            this.cboChannel.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left)
                        | System.Windows.Forms.AnchorStyles.Right)));
            this.cboChannel.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
            this.cboChannel.Location = new System.Drawing.Point(125, 4);
            this.cboChannel.Name = "cboChannel";
            this.cboChannel.Size = new System.Drawing.Size(124, 21);
            this.cboChannel.TabIndex = 6;
            this.cboChannel.SelectedIndexChanged += new System.EventHandler(this.cboChannel_SelectedIndexChanged);
            // 
            // cboDay
            // 
            this.cboDay.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
            this.cboDay.ItemHeight = 13;
            this.cboDay.Location = new System.Drawing.Point(4, 4);
            this.cboDay.MaxDropDownItems = 15;
            this.cboDay.Name = "cboDay";
            this.cboDay.Size = new System.Drawing.Size(116, 21);
            this.cboDay.TabIndex = 7;
            this.cboDay.SelectedIndexChanged += new System.EventHandler(this.cboDay_SelectedIndexChanged);
            // 
            // pnlMid
            // 
            this.pnlMid.Controls.Add(this.lvw1);
            this.pnlMid.Controls.Add(this.lvwSearch);
            this.pnlMid.Dock = System.Windows.Forms.DockStyle.Top;
            this.pnlMid.Location = new System.Drawing.Point(0, 30);
            this.pnlMid.Name = "pnlMid";
            this.pnlMid.Padding = new System.Windows.Forms.Padding(4, 1, 4, 1);
            this.pnlMid.Size = new System.Drawing.Size(252, 224);
            this.pnlMid.TabIndex = 8;
            // 
            // lvw1
            // 
            this.lvw1.AutoArrange = false;
            this.lvw1.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
            this.columnHeader1,
            this.columnHeader2,
            this.columnHeader3});
            this.lvw1.ContextMenu = this.contextMenu1;
            this.lvw1.Dock = System.Windows.Forms.DockStyle.Fill;
            this.lvw1.FullRowSelect = true;
            this.lvw1.HideSelection = false;
            this.lvw1.Location = new System.Drawing.Point(4, 1);
            this.lvw1.MultiSelect = false;
            this.lvw1.Name = "lvw1";
            this.lvw1.Size = new System.Drawing.Size(244, 222);
            this.lvw1.TabIndex = 0;
            this.lvw1.UseCompatibleStateImageBehavior = false;
            this.lvw1.View = System.Windows.Forms.View.Details;
            this.lvw1.SelectedIndexChanged += new System.EventHandler(this.lvw1_SelectedIndexChanged);
            this.lvw1.Layout += new System.Windows.Forms.LayoutEventHandler(this.lvw1_Layout);
            // 
            // columnHeader1
            // 
            this.columnHeader1.Text = "";
            this.columnHeader1.Width = 70;
            // 
            // columnHeader2
            // 
            this.columnHeader2.Text = "";
            this.columnHeader2.Width = 70;
            // 
            // columnHeader3
            // 
            this.columnHeader3.Text = "";
            this.columnHeader3.Width = 210;
            // 
            // contextMenu1
            // 
            this.contextMenu1.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
            this.mnuSetTimer});
            // 
            // mnuSetTimer
            // 
            this.mnuSetTimer.Index = 0;
            this.mnuSetTimer.Text = "Set a DigiTV timer";
            this.mnuSetTimer.Click += new System.EventHandler(this.menuItem4_Click);
            // 
            // lvwSearch
            // 
            this.lvwSearch.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
            this.programme,
            this.date});
            this.lvwSearch.ContextMenu = this.contextMenu1;
            this.lvwSearch.Dock = System.Windows.Forms.DockStyle.Fill;
            this.lvwSearch.FullRowSelect = true;
            this.lvwSearch.LabelWrap = false;
            this.lvwSearch.Location = new System.Drawing.Point(4, 1);
            this.lvwSearch.MultiSelect = false;
            this.lvwSearch.Name = "lvwSearch";
            this.lvwSearch.Size = new System.Drawing.Size(244, 222);
            this.lvwSearch.TabIndex = 1;
            this.lvwSearch.UseCompatibleStateImageBehavior = false;
            this.lvwSearch.View = System.Windows.Forms.View.Details;
            this.lvwSearch.SelectedIndexChanged += new System.EventHandler(this.lvwSearch_SelectedIndexChanged);
            this.lvwSearch.Layout += new System.Windows.Forms.LayoutEventHandler(this.lvwSearch_Layout);
            // 
            // programme
            // 
            this.programme.Text = "";
            this.programme.Width = 120;
            // 
            // date
            // 
            this.date.Text = "";
            // 
            // splitter1
            // 
            this.splitter1.BackColor = System.Drawing.SystemColors.Control;
            this.splitter1.Dock = System.Windows.Forms.DockStyle.Top;
            this.splitter1.Location = new System.Drawing.Point(0, 254);
            this.splitter1.MinExtra = 50;
            this.splitter1.MinSize = 50;
            this.splitter1.Name = "splitter1";
            this.splitter1.Size = new System.Drawing.Size(252, 3);
            this.splitter1.TabIndex = 9;
            this.splitter1.TabStop = false;
            this.splitter1.SplitterMoving += new System.Windows.Forms.SplitterEventHandler(this.splitter1_SplitterMoving);
            // 
            // sbr1
            // 
            this.sbr1.Location = new System.Drawing.Point(0, 391);
            this.sbr1.Name = "sbr1";
            this.sbr1.Panels.AddRange(new System.Windows.Forms.StatusBarPanel[] {
            this.statusBarPanel1});
            this.sbr1.ShowPanels = true;
            this.sbr1.Size = new System.Drawing.Size(252, 22);
            this.sbr1.TabIndex = 11;
            // 
            // statusBarPanel1
            // 
            this.statusBarPanel1.AutoSize = System.Windows.Forms.StatusBarPanelAutoSize.Spring;
            this.statusBarPanel1.BorderStyle = System.Windows.Forms.StatusBarPanelBorderStyle.None;
            this.statusBarPanel1.Name = "statusBarPanel1";
            this.statusBarPanel1.Width = 236;
            // 
            // panel1
            // 
            this.panel1.Controls.Add(this.txtDescSearch);
            this.panel1.Controls.Add(this.textBox1);
            this.panel1.Dock = System.Windows.Forms.DockStyle.Fill;
            this.panel1.Location = new System.Drawing.Point(0, 257);
            this.panel1.Name = "panel1";
            this.panel1.Padding = new System.Windows.Forms.Padding(4, 1, 4, 6);
            this.panel1.Size = new System.Drawing.Size(252, 134);
            this.panel1.TabIndex = 12;
            // 
            // txtDescSearch
            // 
            this.txtDescSearch.Dock = System.Windows.Forms.DockStyle.Fill;
            this.txtDescSearch.Location = new System.Drawing.Point(4, 1);
            this.txtDescSearch.Multiline = true;
            this.txtDescSearch.Name = "txtDescSearch";
            this.txtDescSearch.ScrollBars = System.Windows.Forms.ScrollBars.Vertical;
            this.txtDescSearch.Size = new System.Drawing.Size(244, 127);
            this.txtDescSearch.TabIndex = 1;
            // 
            // textBox1
            // 
            this.textBox1.Dock = System.Windows.Forms.DockStyle.Fill;
            this.textBox1.Location = new System.Drawing.Point(4, 1);
            this.textBox1.Multiline = true;
            this.textBox1.Name = "textBox1";
            this.textBox1.ScrollBars = System.Windows.Forms.ScrollBars.Vertical;
            this.textBox1.Size = new System.Drawing.Size(244, 127);
            this.textBox1.TabIndex = 0;
            // 
            // btnSearch
            // 
            this.btnSearch.FlatStyle = System.Windows.Forms.FlatStyle.System;
            this.btnSearch.Location = new System.Drawing.Point(4, 5);
            this.btnSearch.Name = "btnSearch";
            this.btnSearch.Size = new System.Drawing.Size(72, 20);
            this.btnSearch.TabIndex = 13;
            this.btnSearch.Text = "";
            this.btnSearch.Click += new System.EventHandler(this.btnSearch_Click);
            // 
            // txtSearch
            // 
            this.txtSearch.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left)
                        | System.Windows.Forms.AnchorStyles.Right)));
            this.txtSearch.Location = new System.Drawing.Point(82, 5);
            this.txtSearch.Name = "txtSearch";
            this.txtSearch.Size = new System.Drawing.Size(165, 21);
            this.txtSearch.TabIndex = 14;
            this.txtSearch.TextChanged += new System.EventHandler(this.txtSearch_TextChanged);
            this.txtSearch.KeyPress += new System.Windows.Forms.KeyPressEventHandler(this.txtSearch_KeyPress);
            // 
            // backgroundWorker1
            // 
            this.backgroundWorker1.DoWork += new System.ComponentModel.DoWorkEventHandler(this.backgroundWorker1_DoWork);
            this.backgroundWorker1.RunWorkerCompleted += new System.ComponentModel.RunWorkerCompletedEventHandler(this.backgroundWorker1_RunWorkerCompleted);
            // 
            // Form1
            // 
            this.AutoScaleBaseSize = new System.Drawing.Size(5, 14);
            this.ClientSize = new System.Drawing.Size(252, 413);
            this.Controls.Add(this.txtSearch);
            this.Controls.Add(this.cboChannel);
            this.Controls.Add(this.btnSearch);
            this.Controls.Add(this.panel1);
            this.Controls.Add(this.sbr1);
            this.Controls.Add(this.splitter1);
            this.Controls.Add(this.pnlMid);
            this.Controls.Add(this.cboDay);
            this.Controls.Add(this.pnlTop);
            this.Font = new System.Drawing.Font("Tahoma", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.Icon = ((System.Drawing.Icon)(resources.GetObject("$this.Icon")));
            this.Menu = this.mainMenu1;
            this.MinimumSize = new System.Drawing.Size(260, 400);
            this.Name = "Form1";
            this.Text = "XMLTV EPG Viewer";
            this.Load += new System.EventHandler(this.Form1_Load);
            this.FormClosed += new System.Windows.Forms.FormClosedEventHandler(this.Form1_FormClosed);
            this.Closing += new System.ComponentModel.CancelEventHandler(this.Form1_Closing);
            this.ResizeEnd += new System.EventHandler(this.Form1_ResizeEnd);
            this.pnlMid.ResumeLayout(false);
            ((System.ComponentModel.ISupportInitialize)(this.statusBarPanel1)).EndInit();
            this.panel1.ResumeLayout(false);
            this.panel1.PerformLayout();
            this.ResumeLayout(false);
            this.PerformLayout();

        }
        #endregion

        /// <summary>
        /// The main entry point for the application.
        /// </summary>
        [STAThread]
        static void Main()
        {
            Application.ThreadException += new System.Threading.ThreadExceptionEventHandler(ThreadExceptionFunction);
            Application.SetUnhandledExceptionMode(UnhandledExceptionMode.CatchException);
            AppDomain.CurrentDomain.UnhandledException += new UnhandledExceptionEventHandler(UnhandledExceptionFunction);

            General.EnableVisualStyles = true; // use visual style by default if there is no reg key

            RegistryKey key = Registry.CurrentUser.OpenSubKey(@"Software\XMLTV EPG Viewer");

            if (key != null)
            {
                try
                {
                    General.EnableVisualStyles = bool.Parse(key.GetValue("EnableVisualStyles", true).ToString());
                }
                catch (Exception)
                {
                    //General.EnableVisualStyles = false;
                }
                key.Close();
            }


            General.InitialEnableVisualStyles = General.EnableVisualStyles;

            if (General.EnableVisualStyles)
            {
                Application.EnableVisualStyles();
            }
            try
            {
                Application.Run(new Form1());
            }
            catch (Exception e)
            {
                MessageBox.Show("Unexpected error: " + e.Message, "Unexpected Error", MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
            }
        }




        [System.Runtime.InteropServices.DllImport("user32")]
        public static extern int ShowScrollBar(IntPtr hwnd, int wBar, int bShow);

        //		[System.Runtime.InteropServices.DllImport("kernel32.dll", SetLastError=true)] 
        //		static extern int CreateFileMappingA  ( int hFile, ref SECURITY_ATTRIBUTES lpFileMappigAttributes,  int flProtect,  int dwMaximumSizeHigh,  int dwMaximumSizeLow,  string  lpName);

        [System.Runtime.InteropServices.DllImport("user32.dll")]
        static extern IntPtr SetActiveWindow(IntPtr hWnd);

        [System.Runtime.InteropServices.DllImport("User32.Dll")]
        static extern IntPtr SendMessage(int hWnd, uint Msg, int wParam, int lParam);

        [System.Runtime.InteropServices.DllImport("user32.dll")]
        public static extern int FindWindow(string className, string windowName);

        //[System.Runtime.InteropServices.DllImport("user32.dll", EntryPoint = "LockWindowUpdate")]
        //static extern Int32 LockWindowUpdate(long Int32hwnd);

        private static void ThreadExceptionFunction(object sender, System.Threading.ThreadExceptionEventArgs e)
        {
            //MessageBox.Show("Thread exception: " + e.Exception.Message, "Unexpected Error", MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
            FileInfo f = new FileInfo(@Application.StartupPath + @"\errorlog.log");
            TextWriter tw = f.AppendText();
            tw.WriteLine(DateTime.Now.ToString() + " Thread exception: " + e.Exception.Message);
            tw.Close();
        }

        private static void UnhandledExceptionFunction(object sender, UnhandledExceptionEventArgs e)
        {
            Exception ex = (Exception)(e.ExceptionObject);
            FileInfo f = new FileInfo(@Application.StartupPath + @"\errorlog.log");
            TextWriter tw = f.AppendText();
            tw.WriteLine(DateTime.Now.ToString() + " Unhandled exception: " + ex.Message);
            tw.Close();
        }

        private void OpenXMLFile(string File)
        {
            strFileNameOnly = Path.GetFileName(File);

            //this.Cursor = Cursors.WaitCursor;
            //this.Refresh();

            sbr1.Panels[0].Text = "  " + strFileNameOnly + ". , ...";
            sbr1.Refresh();

            cboChannel.Items.Clear();
            cboChannel.Enabled = false;
            cboDay.Items.Clear();
            cboDay.Enabled = false;
            lvw1.Items.Clear();
            textBox1.Text = "";
            txtSearch.Text = "";
            txtSearch.Enabled = false;
            btnSearch.Enabled = false;
            lvwSearch.Items.Clear();
            txtDescSearch.Text = "";
            sbr1.Focus();

            
            m_xmldoc = new XmlDocument();
                        
            this.Cursor = Cursors.AppStarting;
            foreach (Control ctl in this.Controls)
            {
                if (ctl.Name != "splitter1")
                    ctl.Cursor = Cursors.AppStarting;
            }
            textBox1.Cursor= Cursors.AppStarting;

            try
            {
                FileToLoad = File;
                //Cursor.Current = Cursors.AppStarting;
                Refresh();
                backgroundWorker1.RunWorkerAsync();
            }
            catch (XmlException ex)
            {
                m_xmldoc = null;
                string strMsg = " '" + strFileNameOnly + "'    XML-." + Environment.NewLine + ex.Message;
                MessageBoxEx.Show(this, strMsg, " XML-", MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
            }
            catch (OutOfMemoryException)
            {
                m_xmldoc = null;
                MessageBoxEx.Show(this, "     " + strFileNameOnly + "." + Environment.NewLine + "       ,     .", " ", MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
            }
            catch (FileNotFoundException)
            {
                m_xmldoc = null;
                MessageBoxEx.Show(this, " '" + strFileNameOnly + "'  .", "  ", MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
            }
            catch (Exception ex)
            {
                m_xmldoc = null;
                MessageBoxEx.Show(this, "    " + strFileNameOnly + "." + Environment.NewLine + ex.Message, "", MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
            }

            //this.Cursor = Cursors.Default;
            
        }

        private void GetChannels(XmlNodeList nodelist)
        {
            MyListBoxItem lbi = new MyListBoxItem();
            cboChannel.Items.Clear();
            //mnuSettings.Enabled=false;
            foreach (XmlNode nod in nodelist)
            {
                lbi.itemText = nod.InnerText;
                lbi.itemData = nod.Attributes.Item(0).Value;

                cboChannel.Items.Add(lbi);
                //mnuSettings.Enabled=General.bDigiTVInstalled;
            }
        }

        private void GetDates(XmlNodeList nodelist)
        {
            string strTodayNumeric = DateTime.Today.ToString("yyyymmdd");
            string strTodayStandard = DateTime.Today.ToString("ddd d MMMM yyyy");
            cboDay.Sorted = false;

            MyListBoxItem lbi = new MyListBoxItem();
            cboDay.Items.Clear();

            foreach (XmlNode nod in nodelist)
            {
                XmlAttributeCollection attrColl = nod.Attributes;

                string strDateNumeric = attrColl.GetNamedItem("start").Value.ToString();
                strDateNumeric = strDateNumeric.Substring(0, 8);
                DateTime dtDate = new DateTime(Int32.Parse(strDateNumeric.Substring(0, 4)), Int32.Parse(strDateNumeric.Substring(4, 2)), Int32.Parse(strDateNumeric.Substring(6, 2)));
                string strDateNormal = dtDate.ToString("ddd d MMMM");
                int intFound = cboDay.FindStringExact(strDateNumeric);
                if (intFound < 0)
                {
                    lbi.itemText = strDateNumeric; //strDateNormal;
                    lbi.itemData = strDateNormal; //strDateNumeric;
                    cboDay.Items.Add(lbi);
                }
            }
            cboDay.Sorted = true;
            cboDay.Sorted = false;
            string temp = "";

            for (int n = 0; n <= cboDay.Items.Count - 1; n++)
            {
                lbi = (MyListBoxItem)cboDay.Items[n];
                temp = lbi.itemText;
                lbi.itemText = lbi.itemData;
                lbi.itemData = temp;
                cboDay.Items[n] = lbi;
            }


        }

        private void GoToNow()
        {
            int intFound = -1;
            int intProgStart;
            int intProgStop;
            int intNow = Int32.Parse(DateTime.Now.ToString("HHmm"));
            ListViewItem itm;

            for (int i = 0; i <= lvw1.Items.Count - 1; i++)
            {
                itm = lvw1.Items[i];

                intProgStart = Int32.Parse(itm.Text.Replace(":", ""));
                intProgStop = Int32.Parse(itm.SubItems[1].Text.Replace(":", ""));

                if (intProgStop < intProgStart)
                {
                    intProgStop = +2400;
                }

                if (intNow >= intProgStart && intNow <= intProgStop)
                {
                    intFound = i;
                    break;
                }
            }
            if (intFound >= 0)
            {
                lvw1.Items[intFound].Selected = true;
            }
            else
            {
                if (lvw1.Items.Count >= 1) { lvw1.Items[0].Selected = true; }
            }
            if (lvw1.Items.Count > 0)
            {
                lvw1.SelectedItems[0].EnsureVisible();
            }
        }

        private void Form1_Load(object sender, System.EventArgs e)
        {
            mruManager = new MRUManager();
            mruManager.Initialize(this, mnuFileMRU, "Software\\XMLTV EPG Viewer");
            Microsoft.Win32.SystemEvents.DisplaySettingsChanged += new System.EventHandler(displaySettingsChanged);

            bool bMaximized;
            int intSplitPos;

            string strLastFile = "";
            btnSearch.Enabled = false;
            //mnuSettings.Enabled=false;
            mnuSetTimer.Enabled = false;
            cboDay.Visible = false;
            cboChannel.Visible = false;
            textBox1.Text = "";
            textBox1.ReadOnly = true;
            textBox1.BackColor = System.Drawing.SystemColors.Window;
            txtDescSearch.Text = "";
            txtDescSearch.ReadOnly = true;
            txtDescSearch.BackColor = System.Drawing.SystemColors.Window;
            ShowScrollBar(lvw1.Handle, 0, -1);

            // set defaults if no reg key exists

            General.LoadLastFile = true;
            General.RestrictDropdownHeight = true;

            RegistryKey key = Registry.CurrentUser.OpenSubKey(@"Software\XMLTV EPG Viewer");
            if (key != null)
            {
                try
                {
                    try
                    {
                        General.LoadLastFile = bool.Parse(key.GetValue("LoadLastFile", true).ToString());
                    }
                    catch (Exception)
                    {
                        
                    }
                    try
                    {
                        General.Twenty4HourView = bool.Parse(key.GetValue("24HourView", false).ToString());
                    }
                    catch (Exception)
                    {
                        
                    }
                    try
                    {
                        General.bStartDigiTV = bool.Parse(key.GetValue("StartDigiTV", false).ToString());
                    }
                    catch (Exception)
                    {
                        
                    }
                    try
                    {
                        General.RestrictDropdownHeight = bool.Parse(key.GetValue("RestrictDropdownHeight", true).ToString());
                    }
                    catch (Exception)
                    {
                        
                    }

                    if (General.LoadLastFile == true)
                    {
                        strLastFile = key.GetValue("LastFile", "").ToString();
                    }

                    try
                    {
                        bMaximized = bool.Parse(key.GetValue("Maximized", false).ToString());
                    }
                    catch (Exception)
                    {
                        bMaximized = false;
                    }
                    
                    if (bMaximized)
                    {
                        this.WindowState = FormWindowState.Maximized;
                    }
                    else
                    {
                        this.Height = (int)key.GetValue("Height", this.Height);
                        this.Top = (int)key.GetValue("Top", this.Top);
                        this.Width = (int)key.GetValue("Width", this.Width);
                        this.Left = (int)key.GetValue("Left", this.Left);
                    }
                    try
                    {
                        intSplitPos = (int)key.GetValue("SplitterPos", this.Height / 2);
                    }
                    catch (Exception)
                    {
                        intSplitPos = (int)this.Height / 2;
                    } 
                    splitter1.SplitPosition = intSplitPos;
                    //check for null

                    General.FontName = key.GetValue("FontName", SystemInformation.MenuFont.Name).ToString();

                    if (General.FontName.Trim() == "")
                    {
                        General.FontName = SystemInformation.MenuFont.Name;
                    }

                    bool foundfont = false;

                    InstalledFontCollection fonts = new InstalledFontCollection();

                    foreach (FontFamily family in fonts.Families)
                    {
                        if (family.IsStyleAvailable(FontStyle.Regular))
                        {
                            if (General.FontName == family.GetName(0))
                            {
                                foundfont = true;
                                break;
                            }
                        }
                    }

                    if (!foundfont)
                        General.FontName = "Tahoma";

                    string tmp = Convert.ToString(key.GetValue("FontSize", SystemInformation.MenuFont.SizeInPoints));

                    try
                    {
                        General.FontSize = float.Parse(tmp);
                        if (General.FontSize < 5 || General.FontSize > 49)
                            General.FontSize = 8.25F;
                    }
                    catch (Exception)
                    {
                        General.FontSize = 8.25F;
                    }
                    int argb;
                    string t = key.GetValue("TodayColour", "WindowText").ToString();
                    General.todayColour = Color.FromName(t);
                    if (!General.todayColour.IsKnownColor)

                        try
                        {
                            argb = int.Parse(t);
                            if (argb < 0)
                            {
                                General.todayColour = Color.FromArgb(argb);
                            }
                            else
                            {
                                General.todayColour = Color.FromName("WindowText");
                            }
                        }
                        catch (Exception)
                        {
                            General.todayColour = Color.FromName("WindowText");
                        }

                    t = key.GetValue("TomorrowColour", "WindowText").ToString();

                    General.tomorrowColour = Color.FromName(t);

                    if (!General.tomorrowColour.IsKnownColor)
                        try
                        {
                            argb = int.Parse(t);
                            if (argb < 0)
                            {
                                General.tomorrowColour = Color.FromArgb(argb);
                            }
                            else
                            {
                                General.tomorrowColour = Color.FromName("WindowText");
                            }
                        }
                        catch (Exception)
                        {
                            General.tomorrowColour = Color.FromName("WindowText");
                        }
                }
                catch (Exception)
                { }
                key.Close();
            }

            this.Font = new System.Drawing.Font(General.FontName, General.FontSize);

            Graphics g = this.CreateGraphics();

            SizeF s = g.MeasureString("WWW 99 Februaryy", this.Font);

            cboDay.Width = (int)(s.Width);

            fontheight = s.Height;

            g.Dispose();

            pnlTop.Height = cboChannel.Height + 8;

            lvw1.HeaderStyle = ColumnHeaderStyle.None;
            lvw1.Items.Clear();
            lvwSearch.HeaderStyle = ColumnHeaderStyle.None;
            lvwSearch.Items.Clear();

            mnuListingsView_Click(this, null);

            this.Show();

            if (General.RestrictDropdownHeight)
                workingareaheight = this.Height - SystemInformation.MenuHeight - cboChannel.Height;
            else
                workingareaheight = SystemInformation.WorkingArea.Height;

            textBox1.Focus();
            txtSearch.Focus();

            this.Refresh();
            Application.DoEvents();

            // check if DigiTV is installed

            key = Registry.LocalMachine.OpenSubKey(@"Software\Nebula\DigiTV");
            if (key != null)
            {
                General.strDigiPath = key.GetValue("DigiTV Directory").ToString();

                if (General.strDigiPath != null)
                {
                    string strTempDigiPath = "";

                    strTempDigiPath = General.strDigiPath + "DigiTV.exe";
                    if (System.IO.File.Exists(@strTempDigiPath))
                    {
                        General.bDigiTVInstalled = true;
                        General.strDigiPath = strTempDigiPath;
                    }
                    else
                    {
                        strTempDigiPath = General.strDigiPath + "DigiTV-HD.exe";

                        // check version (3.7 and later increased timers to 100)
                        FileVersionInfo myFI = FileVersionInfo.GetVersionInfo(strTempDigiPath);
                        if (myFI.FileMajorPart >= 3)
                        {
                            if (myFI.FileMinorPart >= 7)
                                General.TimerLimit = 99;
                            else
                                General.TimerLimit = 49;
                        }
                        else
                        {
                            General.TimerLimit = 49;
                        }

                        if (System.IO.File.Exists(@strTempDigiPath))
                        {
                            General.bDigiTVInstalled = true;
                            General.strDigiPath = strTempDigiPath;
                        }
                        else
                        {
                            General.bDigiTVInstalled = false;
                            General.strDigiPath = "";
                        }
                    }
                }
                key.Close();
            }


            if (General.LoadLastFile)
            {
                if (strLastFile.Trim() != "")
                {
                    OpenXMLFile(strLastFile);
                }
                else
                {
                    sbr1.Panels[0].Text = ",     XMLTV";
                    sbr1.Focus();
                }
            }
            else
            {
                sbr1.Panels[0].Text = ",     XMLTV";
                sbr1.Focus();
            }
            
            SizeControls();
        }

        private void cboChannel_SelectedIndexChanged(object sender, System.EventArgs e)
        {
            if (!bLoading)
            {
                if (cboDay.SelectedIndex != -1)
                {
                    ShowListings();
                }
            }
        }


        private void cboDay_SelectedIndexChanged(object sender, System.EventArgs e)
        {
            if (!bLoading)
            {
                
                if (cboChannel.SelectedIndex != -1)
                {
                    ShowListings();
                }
            }
        }


        private void lvw1_SelectedIndexChanged(object sender, System.EventArgs e)
        {
            textBox1.Clear();
            ProgrammeDetail det;
            mnuSetTimer.Enabled = false;
            string strDesc;
            if (lvw1.SelectedItems.Count == 1)
            {
                ListViewItem li = lvw1.SelectedItems[0];
                det = (ProgrammeDetail)li.Tag;
                if (det.Subtitle.Trim() != "")
                {
                    strDesc = det.Subtitle + ". " + det.Desc;
                }
                else
                {
                    strDesc = det.Desc;
                }
                textBox1.Text = strDesc;
                if (textBox1.Text == "") { textBox1.Text = "[ ]"; }
                mnuSetTimer.Enabled = General.bDigiTVInstalled;
            }
        }


        private void Form1_Closing(object sender, System.ComponentModel.CancelEventArgs e)
        {
            this.Hide();

            RegistryKey key = Registry.CurrentUser.CreateSubKey(@"Software\XMLTV EPG Viewer");
            if (this.WindowState == FormWindowState.Normal)
            {
                key.SetValue("Height", this.Height);
                key.SetValue("Width", this.Width);
                key.SetValue("Top", this.Top);
                key.SetValue("Left", this.Left);
                bool max = false;
                key.SetValue("Maximized", max);

            }
            if (this.WindowState == FormWindowState.Maximized)
            {
                bool max = true;
                key.SetValue("Maximized", max);
            }
            key.SetValue("SplitterPos", splitter1.SplitPosition);
            key.SetValue("LastFile", strCurrentFile);

            if (General.bStartDigiTV == true && General.TimersSet == true)
            {
                int f = FindWindow("DIGITV", null);
                if (f == 0) // not running - so start it
                {
                    this.Refresh();
                    int OldSystray = -1;
                    RegistryKey keyS = Registry.LocalMachine.OpenSubKey(@"Software\Nebula\DigiTV", true);
                    if (keyS != null)
                    {
                        OldSystray = General.BinaryToInt((byte[])keyS.GetValue("Systray")); //save it
                        byte[] bytsystray = General.IntToBinary(1);
                        keyS.SetValue("Systray", bytsystray);
                    }

                    Process DigiTV = new Process();

                    DigiTV.StartInfo.FileName = @General.strDigiPath;
                    DigiTV.StartInfo.WindowStyle = ProcessWindowStyle.Minimized;

                    DigiTV.Start();
                    DigiTV.WaitForExit(1000);
                    DigiTV.Dispose();

                    int h = FindWindow("DIGITV", null);
                    SetActiveWindow((IntPtr)h);
                    SendMessage((int)h, WM_SYSCOMMAND, SC_CLOSE, 0);
                    if (OldSystray != -1)
                        keyS.SetValue("Systray", General.IntToBinary(OldSystray));

                }
            }
        }

        private void splitter1_SplitterMoving(object sender, System.Windows.Forms.SplitterEventArgs e)
        {
            splitter1.SplitPosition += 0;
        }
        private void MoveToToday()
        {
            int intTodayIndex = -1;
            if (cboDay.Items.Count > 0)
            {
                for (int i = 0; i <= cboDay.Items.Count - 1; i++)
                {
                    MyListBoxItem li = (MyListBoxItem)(cboDay.Items[i]);
                    if (li.itemText == DateTime.Today.ToString("ddd d MMMM"))
                    {
                        intTodayIndex = i;
                    }
                }
                cboDay.SelectedIndex = intTodayIndex;
            }

            if (cboChannel.Items.Count > 0) { cboChannel.SelectedIndex = 0; }
        }

        private void mnuFileOpen_Click(object sender, System.EventArgs e)
        {
            dlgOpen.CheckFileExists = true;
            dlgOpen.CheckPathExists = true;
            dlgOpen.Filter = "XML- (*.xml)|*.xml";
            if (dlgOpen.ShowDialog() == DialogResult.OK)
            {
                this.Refresh();

                OpenXMLFile(dlgOpen.FileName);
            }
        }


        private void mnuAbout_Click(object sender, System.EventArgs e)
        {
            Version vs = new Version(Application.ProductVersion);
            string vers = vs.Major.ToString() + "." + vs.Minor.ToString() + "." + vs.Build.ToString() + "." + vs.MinorRevision.ToString();
            MessageBoxEx.Show(this, "     XMLTV" + Environment.NewLine + Environment.NewLine + " " + vers + " " + General.beta + Environment.NewLine + Environment.NewLine + " Ian Bishop", "  XMLTV EPG Viewer", MessageBoxButtons.OK, MessageBoxIcon.Information);
        }

        private void mnuExit_Click(object sender, System.EventArgs e)
        {
            this.Close();
        }

        private void lvw1_Layout(object sender, System.Windows.Forms.LayoutEventArgs e)
        {
            lvw1.Columns[2].Width = -2;
        }


        private void mnuSettings_Click(object sender, System.EventArgs e)
        {
            Form3 frm3 = new Form3(cboChannel, this, (m_xmldoc != null));

            frm3.ShowDialog(this);

            DialogResult res1 = frm3.DialogResult;

            if (res1 == DialogResult.OK)
            {
                if (General.RestrictDropdownHeight)
                    workingareaheight = this.Height - SystemInformation.MenuHeight - cboChannel.Height;
                else
                    workingareaheight = SystemInformation.WorkingArea.Height;

                dropitems = (int)((float)workingareaheight / fontheight);
                cboChannel.MaxDropDownItems = dropitems;
                cboDay.MaxDropDownItems = dropitems;

                if (General.FontChanged)
                {
                    this.Font = new Font(General.FontName, General.FontSize);
                    SizeListViews();
                    SizeControls();

                }
                if (General.RefreshNeeded)
                {
                    ShowListings();
                }
                if (General.EnableVisualStyles != General.InitialEnableVisualStyles)
                {
                    DialogResult res = MessageBoxEx.Show(this, "    ,   .\r\n\r\n  ?", " ", MessageBoxButtons.YesNo, MessageBoxIcon.Question, MessageBoxDefaultButton.Button1);
                    if (res == DialogResult.Yes)
                    {
                        // Shut down the current app instance
                        Form1_Closing(this, null);
                        Application.Exit();

                        // Restart the app
                        System.Diagnostics.Process.Start(Application.ExecutablePath);
                    }
                }

            }
            if (res1 == DialogResult.Cancel)
            {
                if (General.FontChanged)
                {
                    this.Font = new Font(General.FontName, General.FontSize);
                    SizeListViews();
                    SizeControls();

                }
            }
        }



        private void menuItem4_Click(object sender, System.EventArgs e)
        {
            ListView lvw;
            int n;

            if (lvw1.Visible)
            {
                lvw = lvw1;
                n = 2;
            }
            else
            {
                lvw = lvwSearch;
                n = 0;
            }

            if (lvw.SelectedItems[0] != null)
            {
                MyListBoxItem lbi = new MyListBoxItem();
                lbi = (MyListBoxItem)cboChannel.SelectedItem;
                ProgrammeDetail det = (ProgrammeDetail)lvw.SelectedItems[0].Tag;


                try
                {
                    bool status = General.SetTimer(det.Start, det.ChannelID, det.Duration, lvw.SelectedItems[0].SubItems[n].Text);
                    if (status == true)
                    {
                        General.TimersSet = true;
                        MessageBoxEx.Show(this, "Timer sucessfully set for '" + lvw.SelectedItems[0].SubItems[n].Text + "'.", "Timer set", MessageBoxButtons.OK, MessageBoxIcon.Information);
                    }
                }
                catch (Exception ex)
                {
                    MessageBoxEx.Show(this, ex.Message, "Timer error", MessageBoxButtons.OK, MessageBoxIcon.Warning);
                }
            }
        }

        private void btnSearch_Click(object sender, System.EventArgs e)
        {
            btnSearch.Enabled = false;
            sbr1.Panels[0].Text = "...";
            txtDescSearch.Text = "";
            lvwSearch.SelectedItems.Clear();
            lvwSearch.Items.Clear();
            lvwSearch.Refresh();

            Cursor = Cursors.WaitCursor;
            this.Refresh();

            lvwSearch.BeginUpdate();

            ProgrammeDetail det = new ProgrammeDetail();
            foreach (XmlNode nod in m_xmldoc.GetElementsByTagName("programme"))
            {
                XmlAttributeCollection attrColl = nod.Attributes;
                string strLongStartDate = attrColl.GetNamedItem("start").Value;

                string strStartDate = strLongStartDate.Substring(0, 8);

                MyListBoxItem lbi;
                string ChannelName = "";
                string strChannelID = attrColl.GetNamedItem("channel").Value;
                string strTime = attrColl.GetNamedItem("start").Value.Substring(8, 4);
                string strHour = strTime.Substring(0, 2);
                string strMin = strTime.Substring(2, 2);
                string strStartTime = strHour + ":" + strMin;
                strTime = attrColl.GetNamedItem("stop").Value.Substring(8, 4);
                strHour = strTime.Substring(0, 2);
                strMin = strTime.Substring(2, 2);
                string strStopTime = strHour + ":" + strMin;
                bool bFound = false;

                ListViewItem li = null;

                det.Desc = "";
                det.Subtitle = "";

                for (int n = 0; n <= cboChannel.Items.Count - 1; n++)
                {
                    lbi = (MyListBoxItem)cboChannel.Items[n];
                    if (lbi.itemData == strChannelID)
                    {
                        ChannelName = lbi.itemText;
                    }
                }

                DateTime dt = new DateTime(int.Parse(strLongStartDate.Substring(0, 4)), int.Parse(strLongStartDate.Substring(4, 2)), int.Parse(strLongStartDate.Substring(6, 2)), int.Parse(strLongStartDate.Substring(8, 2)), int.Parse(strLongStartDate.Substring(10, 2)), 0, 0);
                det.Start = dt;
                det.ChannelID = strChannelID;
                det.ChannelName = ChannelName;
                bFound = false;

                foreach (XmlNode cnode in nod.ChildNodes)
                {
                    if (cnode.Name == "desc")
                    {
                        det.Desc = cnode.InnerText;
                    }

                    if (cnode.Name == "title")
                        if (cnode.InnerText.ToLower().IndexOf(txtSearch.Text.ToLower()) >= 0)
                        {
                            li = new ListViewItem();
                            li.Text = strStartDate;
                            li.SubItems.Add(cnode.InnerText);
                            bFound = true;
                        }
                    if (cnode.Name == "sub-title") 
                    { 
                        det.Subtitle = cnode.InnerText;
                    }

                    if (cnode.Name == "length")
                    {
                        det.Duration = int.Parse(cnode.InnerText);
                        det.DurUnits = cnode.Attributes["units"].Value;
                    }
                }
                if (bFound)
                {
                    li.Tag = det;
                    lvwSearch.Items.Add(li);
                }
            }

            lvwSearch.Sort();
            DateTime dt2;
            string strTemp = "";
            foreach (ListViewItem itm in lvwSearch.Items)
            {
                dt2 = new DateTime(int.Parse(itm.Text.Substring(0, 4)), int.Parse(itm.Text.Substring(4, 2)), int.Parse(itm.Text.Substring(6, 2)), 0, 0, 0, 0);
                strTemp = dt2.ToString("ddd d MMM");
                itm.Text = itm.SubItems[1].Text;
                itm.SubItems[1].Text = strTemp;
            }

            lvwSearch.Columns[0].Width = -2;
            lvwSearch.Columns[0].Width += 4;
            lvwSearch.Columns[1].Width = -2;

            if (lvwSearch.Items.Count > 0)
            { lvwSearch.HeaderStyle = ColumnHeaderStyle.Clickable; }
            else
            { lvwSearch.HeaderStyle = ColumnHeaderStyle.None; }

            lvwSearch.EndUpdate();
            this.Refresh();
            Cursor = Cursors.Default;

            sbr1.Panels[0].Text = "  " + strFileNameOnly;
            txtSearch.Focus();

        }

        private void lvwSearch_SelectedIndexChanged(object sender, System.EventArgs e)
        {
            txtDescSearch.Clear();
            ProgrammeDetail det;
            mnuSetTimer.Enabled = false;
            if (lvwSearch.SelectedItems.Count == 1)
            {
                string strDesc;
                ListViewItem li = lvwSearch.SelectedItems[0];
                det = (ProgrammeDetail)li.Tag;

                if (det.Subtitle.Trim() != "")
                {
                    strDesc = det.Subtitle + ". " + det.Desc;
                }
                else
                {
                    strDesc = det.Desc;
                }
                
                txtDescSearch.Text = strDesc;
                if (txtDescSearch.Text == "") { txtDescSearch.Text = "[ ]"; }
                txtDescSearch.Text = ": " + det.ChannelName + "\r\n: " + det.Start.ToString("HH:mm") + "\r\n: " + det.Duration + " " + det.DurUnits + "\r\n" + txtDescSearch.Text;
                mnuSetTimer.Enabled = General.bDigiTVInstalled;
            }
        }

        private void txtSearch_KeyPress(object sender, System.Windows.Forms.KeyPressEventArgs e)
        {

            if (e.KeyChar == (char)13)
            {
                e.Handled = true;
                btnSearch_Click(this, null);
            }
        }

        private void mnuListingsView_Click(object sender, System.EventArgs e)
        {
            cboDay.Visible = true;
            cboChannel.Visible = true;
            lvw1.Visible = true;
            textBox1.Visible = true;


            btnSearch.Visible = false;
            txtSearch.Visible = false;
            lvwSearch.Visible = false;
            txtDescSearch.Visible = false;

            mnuSetTimer.Enabled = false;

            pnlTop.Refresh();
        }

        private void mnuSearchView_Click(object sender, System.EventArgs e)
        {
            cboDay.Visible = false;
            cboChannel.Visible = false;
            lvw1.Visible = false;
            textBox1.Visible = false;

            mnuSetTimer.Enabled = false;

            btnSearch.Visible = true;
            txtSearch.Visible = true;
            lvwSearch.Visible = true;
            txtDescSearch.Visible = true;

            pnlTop.Refresh();

            txtSearch.Focus();
        }

        private void ShowListings()
        {
            if (cboChannel.SelectedIndex != -1 && cboDay.SelectedIndex != -1 && !bLoading)
            {
                sbr1.Panels[0].Text = " ...";

                string From = DateTime.Now.ToString("yyyyMMddHHmm");
                string To = DateTime.Now.AddDays(1).ToString("yyyyMMddHHmm");

                MyListBoxItem lbi = (MyListBoxItem)cboDay.SelectedItem;
                string strDate = lbi.itemData;

                lbi = (MyListBoxItem)cboChannel.SelectedItem;
                string ChannelID = lbi.itemData;
                string ChannelName = lbi.itemText;

                if (General.Twenty4HourView)
                {
                    From = strDate + DateTime.Now.ToString("HHmm");
                    DateTime dt = new DateTime(int.Parse(strDate.Substring(0, 4)), int.Parse(strDate.Substring(4, 2)), int.Parse(strDate.Substring(6, 2)), DateTime.Now.Hour, DateTime.Now.Minute, 0);
                    To = dt.AddDays(1).ToString("yyyyMMddHHmm");
                }
                else
                {
                    From = strDate + DateTime.Now.ToString("0001");
                    To = strDate + DateTime.Now.ToString("2359");
                }


                textBox1.Text = "";
                lvw1.SelectedItems.Clear();
                lvw1.Items.Clear();
                lvw1.Refresh();
                Cursor = Cursors.WaitCursor;
                this.Refresh();

                lvw1.BeginUpdate();

                mnuSetTimer.Enabled = false;

                Int64 iFrom = Int64.Parse(From);
                Int64 iTo = Int64.Parse(To);


                ProgrammeDetail det = new ProgrammeDetail();
                foreach (XmlNode nod in m_xmldoc.GetElementsByTagName("programme"))
                {
                    XmlAttributeCollection attrColl = nod.Attributes;

                    string strLongEndDate = attrColl.GetNamedItem("stop").Value;
                    string strEndDate = strLongEndDate.Substring(0, 12);
                    Int64 EndDateTime = Int64.Parse(strEndDate);

                    string strLongStartDate = attrColl.GetNamedItem("start").Value;
                    string strStartDate = strLongStartDate.Substring(0, 12);
                    Int64 StartDateTime = Int64.Parse(strStartDate);


                    string strChannelID = attrColl.GetNamedItem("channel").Value;
                    string strTime = attrColl.GetNamedItem("start").Value.Substring(8, 4);
                    string strHour = strTime.Substring(0, 2);
                    string strMin = strTime.Substring(2, 2);
                    string strStartTime = strHour + ":" + strMin;
                    strTime = attrColl.GetNamedItem("stop").Value.Substring(8, 4);
                    strHour = strTime.Substring(0, 2);
                    strMin = strTime.Substring(2, 2);
                    string strStopTime = strHour + ":" + strMin;

                    if ((StartDateTime <= iTo && EndDateTime >= iFrom) && strChannelID == ChannelID)
                    {
                        ListViewItem li = new ListViewItem();
                        det.Desc = "";
                        det.Subtitle = "";
                        li.Text = strStartTime;
                        li.SubItems.Add(strStopTime);
                        DateTime dt = new DateTime(int.Parse(strLongStartDate.Substring(0, 4)), int.Parse(strLongStartDate.Substring(4, 2)), int.Parse(strLongStartDate.Substring(6, 2)), int.Parse(strLongStartDate.Substring(8, 2)), int.Parse(strLongStartDate.Substring(10, 2)), 0, 0);
                        det.Start = dt;
                        det.ChannelID = ChannelID;
                        det.ChannelName = ChannelName;

                        foreach (XmlNode cnode in nod.ChildNodes)
                        {
                            if (cnode.Name == "title") { li.SubItems.Add(cnode.InnerText); }
                            else if (cnode.Name == "desc") { det.Desc = cnode.InnerText; }
                            else if (cnode.Name == "sub-title") { det.Subtitle = cnode.InnerText; }
                            else if (cnode.Name == "length")
                            {
                                det.Duration = int.Parse(cnode.InnerText);
                                det.DurUnits = cnode.Attributes["units"].Value;
                            }
                        }
                        li.Tag = det;
                        DateTime dt2 = new DateTime(int.Parse(From.Substring(0, 4)), int.Parse(From.Substring(4, 2)), int.Parse(From.Substring(6, 2)), 0, 0, 0);

                        if (dt.Day == dt2.AddDays(1).Day)
                        {
                            li.ForeColor = General.tomorrowColour;
                        }
                        else
                        {
                            li.ForeColor = General.todayColour;
                        }
                        lvw1.Items.Add(li);

                    }
                }
                foreach (ColumnHeader ch in lvw1.Columns)
                {
                    ch.Width = -2;
                }
                if (lvw1.Items.Count > 0)
                { lvw1.HeaderStyle = ColumnHeaderStyle.Clickable; }
                else
                { lvw1.HeaderStyle = ColumnHeaderStyle.None; }

                if (!General.Twenty4HourView)
                {
                    GoToNow();
                }
                lvw1.EndUpdate();

                this.Refresh();

                Cursor = Cursors.Default;
                sbr1.Panels[0].Text = "  " + strFileNameOnly;

            }
        }

        private void mnu24Hours_Click(object sender, System.EventArgs e)
        {
            if (cboDay.SelectedIndex != -1)
            {
                ShowListings();
            }

        }

        private void lvwSearch_Layout(object sender, System.Windows.Forms.LayoutEventArgs e)
        {
            lvwSearch.Columns[1].Width = -2;
        }

        private void txtSearch_TextChanged(object sender, System.EventArgs e)
        {
            if (txtSearch.Text.Trim() == "")
            {
                btnSearch.Enabled = false;
            }
            else
            {
                btnSearch.Enabled = m_xmldoc != null;
            }
        }

        private void backgroundWorker1_DoWork(object sender, DoWorkEventArgs e)
        {

            mnuFileOpen.Enabled = false;
            mnuSettings.Enabled = false;
            mnuListingsView.Enabled = false;
            mnuSearchView.Enabled = false;
            
            m_xmldoc.Load(FileToLoad);
        }

        

        private void backgroundWorker1_RunWorkerCompleted(object sender, RunWorkerCompletedEventArgs e)
        {
            if (m_xmldoc != null)
            {

                XmlNodeList nodelist = m_xmldoc.GetElementsByTagName("channel");

                if (nodelist.Count == 0)
                {
                    mruManager.Remove(FileToLoad);
                    MessageBoxEx.Show(this, " '" + strFileNameOnly + "'    XMLTV.", " ", MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
                    sbr1.Panels[0].Text = ",     XMLTV";
                }
                else
                {
                    mruManager.Add(FileToLoad);
                    GetChannels(nodelist);
                    nodelist = m_xmldoc.GetElementsByTagName("programme");
                    GetDates(nodelist);
                    strCurrentFile = FileToLoad;

                    sbr1.Panels[0].Text = "  " + strFileNameOnly;
                    sbr1.Tag = sbr1.Panels[0].Text;
                }

            }
            else
            {
                strCurrentFile = "";
                sbr1.Panels[0].Text = ",     XMLTV";
                sbr1.Tag = sbr1.Panels[0].Text;
            }
            
            cboChannel.Enabled = true;
            cboDay.Enabled = true;
            mnuSettings.Enabled = true;
            mnuFileOpen.Enabled = true;
            mnuSettings.Enabled = true;
            mnuSearchView.Enabled = true;
            mnuListingsView.Enabled = true;
            cboDay.Enabled = true;
            cboChannel.Enabled = true;
            txtSearch.Enabled = true;

            this.Cursor = Cursors.Default;
            foreach (Control ctl in this.Controls)
            {
                if (ctl.Name != "splitter1")
                    ctl.Cursor = Cursors.Default;
                
            }
            textBox1.Cursor = Cursors.Default;

            if (m_xmldoc != null) { MoveToToday(); cboChannel.Focus(); }
        }

        public void SizeControls()
        {
            this.Font = new Font(General.FontName, General.FontSize);

            pnlTop.Height = cboChannel.Height + 8;

            Graphics g = this.CreateGraphics();

            SizeF s = g.MeasureString("WWW 99 Februaryy", this.Font);

            cboDay.Width = (int)(s.Width);

            //this.Text = s.Height.ToString();

            fontheight = s.Height;
            
            cboChannel.Left = cboDay.Left + cboDay.Width + 4;
            cboChannel.Width = pnlMid.Width - pnlMid.Padding.Left - pnlMid.Padding.Right - cboDay.Width - cboDay.Left;
            
            dropitems = (int)((float)workingareaheight / fontheight);
            cboChannel.MaxDropDownItems = dropitems;
            cboDay.MaxDropDownItems = dropitems;

            sbr1.Height = (int)s.Height + 4;

            btnSearch.Height = txtSearch.Height;
            s = g.MeasureString(btnSearch.Text, this.Font);
            btnSearch.Width = (int)s.Width + 10;

            txtSearch.Left = btnSearch.Left + btnSearch.Width + 4;
            txtSearch.Width = pnlMid.Width - pnlMid.Padding.Left - pnlMid.Padding.Right - btnSearch.Width - btnSearch.Left;
            g.Dispose();

            this.Refresh();
        }

        public void SizeListViews()
        {
            foreach (ColumnHeader ch in lvw1.Columns)
            {
                ch.Width = -2;
            }
            foreach (ColumnHeader ch in lvwSearch.Columns)
            {
                ch.Width = -2;
            }
        }
       

        // Event handler for the system's DisplaySettingsChanged event.
        private void displaySettingsChanged(object sender, EventArgs e)
        {
            
            if (General.RestrictDropdownHeight)
                workingareaheight = this.Height - SystemInformation.MenuHeight - cboChannel.Height;
            else
                workingareaheight = SystemInformation.WorkingArea.Height;

            dropitems = (int)((float)workingareaheight / fontheight);
            cboChannel.MaxDropDownItems = dropitems;
            cboDay.MaxDropDownItems = dropitems;
        }

        private void Form1_FormClosed(object sender, FormClosedEventArgs e)
        {
            Microsoft.Win32.SystemEvents.DisplaySettingsChanged -= displaySettingsChanged;

        }

        private void Form1_ResizeEnd(object sender, EventArgs e)
        {
            //this.Text=SystemInformation.CurrentMonitorSize.Height.ToString() + " " + SystemInformation.WorkingArea.Bottom.ToString();

            if (General.RestrictDropdownHeight)
            {
                workingareaheight = this.Height - SystemInformation.MenuHeight - cboChannel.Height;
                dropitems = (int)((float)workingareaheight / fontheight);
                cboChannel.MaxDropDownItems = dropitems;
                cboDay.MaxDropDownItems = dropitems;

            }
        }
    }	
}
